package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartMetadataModelImportResponse(
    requestIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse = {
    import StartMetadataModelImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse
      .builder()
      .optionallyWith(requestIdentifier.map(value => value: java.lang.String))(
        _.requestIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelImportResponse
      .wrap(buildAwsValue())
}
object StartMetadataModelImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelImportResponse =
      zio.aws.databasemigration.model
        .StartMetadataModelImportResponse(requestIdentifier.map(value => value))
    def requestIdentifier: Optional[String]
    def getRequestIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestIdentifier", requestIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse
  ) extends zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly {
    override val requestIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse
  ): zio.aws.databasemigration.model.StartMetadataModelImportResponse.ReadOnly =
    new Wrapper(impl)
}
