package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartMetadataModelConversionResponse(
    requestIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse = {
    import StartMetadataModelConversionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse
      .builder()
      .optionallyWith(requestIdentifier.map(value => value: java.lang.String))(
        _.requestIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelConversionResponse
      .wrap(buildAwsValue())
}
object StartMetadataModelConversionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelConversionResponse =
      zio.aws.databasemigration.model.StartMetadataModelConversionResponse(
        requestIdentifier.map(value => value)
      )
    def requestIdentifier: Optional[String]
    def getRequestIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestIdentifier", requestIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse
  ) extends zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly {
    override val requestIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse
  ): zio.aws.databasemigration.model.StartMetadataModelConversionResponse.ReadOnly =
    new Wrapper(impl)
}
