package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteInstanceProfileRequest(
    instanceProfileIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest = {
    import DeleteInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest
      .builder()
      .instanceProfileIdentifier(instanceProfileIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteInstanceProfileRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteInstanceProfileRequest
      .wrap(buildAwsValue())
}
object DeleteInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteInstanceProfileRequest =
      zio.aws.databasemigration.model
        .DeleteInstanceProfileRequest(instanceProfileIdentifier)
    def instanceProfileIdentifier: String
    def getInstanceProfileIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(instanceProfileIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest
  ) extends zio.aws.databasemigration.model.DeleteInstanceProfileRequest.ReadOnly {
    override val instanceProfileIdentifier: String =
      impl.instanceProfileIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest
  ): zio.aws.databasemigration.model.DeleteInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
