package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MoveReplicationTaskResponse(
    replicationTask: Optional[zio.aws.databasemigration.model.ReplicationTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse = {
    import MoveReplicationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse
      .builder()
      .optionallyWith(replicationTask.map(value => value.buildAwsValue()))(
        _.replicationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly =
    zio.aws.databasemigration.model.MoveReplicationTaskResponse
      .wrap(buildAwsValue())
}
object MoveReplicationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.MoveReplicationTaskResponse =
      zio.aws.databasemigration.model.MoveReplicationTaskResponse(
        replicationTask.map(value => value.asEditable)
      )
    def replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    def getReplicationTask: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTask", replicationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse
  ) extends zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly {
    override val replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTask())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse
  ): zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
