package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait KafkaSaslMechanism {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism
}
object KafkaSaslMechanism {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism
  ): zio.aws.databasemigration.model.KafkaSaslMechanism = value match {
    case software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism.SCRAM_SHA_512 =>
      val r = `scram-sha-512`
      r
    case software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism.PLAIN =>
      val r = plain
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.KafkaSaslMechanism {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism =
      software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism.UNKNOWN_TO_SDK_VERSION
  }
  case object `scram-sha-512`
      extends zio.aws.databasemigration.model.KafkaSaslMechanism {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism =
      software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism.SCRAM_SHA_512
  }
  case object plain extends zio.aws.databasemigration.model.KafkaSaslMechanism {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism =
      software.amazon.awssdk.services.databasemigration.model.KafkaSaslMechanism.PLAIN
  }
}
