package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFleetAdvisorDatabasesRequest(
    databaseIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest = {
    import DeleteFleetAdvisorDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
      .builder()
      .databaseIds(databaseIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
      .wrap(buildAwsValue())
}
object DeleteFleetAdvisorDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest =
      zio.aws.databasemigration.model
        .DeleteFleetAdvisorDatabasesRequest(databaseIds)
    def databaseIds: List[String]
    def getDatabaseIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(databaseIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
  ) extends zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest.ReadOnly {
    override val databaseIds: List[String] = impl
      .databaseIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
  ): zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest.ReadOnly =
    new Wrapper(impl)
}
