package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFleetAdvisorCollectorRequest(
    collectorName: String,
    description: Optional[String] = Optional.Absent,
    serviceAccessRoleArn: String,
    s3BucketName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest = {
    import CreateFleetAdvisorCollectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest
      .builder()
      .collectorName(collectorName: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .serviceAccessRoleArn(serviceAccessRoleArn: java.lang.String)
      .s3BucketName(s3BucketName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest
      .wrap(buildAwsValue())
}
object CreateFleetAdvisorCollectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest =
      zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest(
        collectorName,
        description.map(value => value),
        serviceAccessRoleArn,
        s3BucketName
      )
    def collectorName: String
    def description: Optional[String]
    def serviceAccessRoleArn: String
    def s3BucketName: String
    def getCollectorName: ZIO[Any, Nothing, String] = ZIO.succeed(collectorName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getServiceAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceAccessRoleArn)
    def getS3BucketName: ZIO[Any, Nothing, String] = ZIO.succeed(s3BucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest
  ) extends zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest.ReadOnly {
    override val collectorName: String = impl.collectorName(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val serviceAccessRoleArn: String =
      impl.serviceAccessRoleArn(): String
    override val s3BucketName: String = impl.s3BucketName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest
  ): zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest.ReadOnly =
    new Wrapper(impl)
}
