package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ReplicationTaskAssessmentRunProgress(
    individualAssessmentCount: Optional[Integer] = Optional.Absent,
    individualAssessmentCompletedCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunProgress = {
    import ReplicationTaskAssessmentRunProgress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunProgress
      .builder()
      .optionallyWith(
        individualAssessmentCount.map(value => value: java.lang.Integer)
      )(_.individualAssessmentCount)
      .optionallyWith(
        individualAssessmentCompletedCount.map(value =>
          value: java.lang.Integer
        )
      )(_.individualAssessmentCompletedCount)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress
      .wrap(buildAwsValue())
}
object ReplicationTaskAssessmentRunProgress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunProgress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress =
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress(
        individualAssessmentCount.map(value => value),
        individualAssessmentCompletedCount.map(value => value)
      )
    def individualAssessmentCount: Optional[Integer]
    def individualAssessmentCompletedCount: Optional[Integer]
    def getIndividualAssessmentCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("individualAssessmentCount", individualAssessmentCount)
    def getIndividualAssessmentCompletedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "individualAssessmentCompletedCount",
        individualAssessmentCompletedCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunProgress
  ) extends zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly {
    override val individualAssessmentCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.individualAssessmentCount())
        .map(value => value: Integer)
    override val individualAssessmentCompletedCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.individualAssessmentCompletedCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentRunProgress
  ): zio.aws.databasemigration.model.ReplicationTaskAssessmentRunProgress.ReadOnly =
    new Wrapper(impl)
}
