package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartMetadataModelAssessmentResponse(
    requestIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse = {
    import StartMetadataModelAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse
      .builder()
      .optionallyWith(requestIdentifier.map(value => value: java.lang.String))(
        _.requestIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly =
    zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse
      .wrap(buildAwsValue())
}
object StartMetadataModelAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse =
      zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse(
        requestIdentifier.map(value => value)
      )
    def requestIdentifier: Optional[String]
    def getRequestIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestIdentifier", requestIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse
  ) extends zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly {
    override val requestIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse
  ): zio.aws.databasemigration.model.StartMetadataModelAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
