package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMetadataModelAssessmentsResponse(
    marker: Optional[String] = Optional.Absent,
    requests: Optional[
      Iterable[zio.aws.databasemigration.model.SchemaConversionRequest]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse = {
    import DescribeMetadataModelAssessmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        requests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requests)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse
      .wrap(buildAwsValue())
}
object DescribeMetadataModelAssessmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse =
      zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse(
        marker.map(value => value),
        requests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def requests: Optional[
      List[zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getRequests: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("requests", requests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse
  ) extends zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val requests: Optional[
      List[zio.aws.databasemigration.model.SchemaConversionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.requests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SchemaConversionRequest.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse
  ): zio.aws.databasemigration.model.DescribeMetadataModelAssessmentsResponse.ReadOnly =
    new Wrapper(impl)
}
