package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.Iso8601DateTime
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DataProvider(
    dataProviderName: Optional[String] = Optional.Absent,
    dataProviderArn: Optional[String] = Optional.Absent,
    dataProviderCreationTime: Optional[Iso8601DateTime] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    settings: Optional[zio.aws.databasemigration.model.DataProviderSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DataProvider = {
    import DataProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DataProvider
      .builder()
      .optionallyWith(dataProviderName.map(value => value: java.lang.String))(
        _.dataProviderName
      )
      .optionallyWith(dataProviderArn.map(value => value: java.lang.String))(
        _.dataProviderArn
      )
      .optionallyWith(
        dataProviderCreationTime.map(value =>
          Iso8601DateTime.unwrap(value): Instant
        )
      )(_.dataProviderCreationTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.DataProvider.ReadOnly =
    zio.aws.databasemigration.model.DataProvider.wrap(buildAwsValue())
}
object DataProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DataProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DataProvider =
      zio.aws.databasemigration.model.DataProvider(
        dataProviderName.map(value => value),
        dataProviderArn.map(value => value),
        dataProviderCreationTime.map(value => value),
        description.map(value => value),
        engine.map(value => value),
        settings.map(value => value.asEditable)
      )
    def dataProviderName: Optional[String]
    def dataProviderArn: Optional[String]
    def dataProviderCreationTime: Optional[Iso8601DateTime]
    def description: Optional[String]
    def engine: Optional[String]
    def settings: Optional[
      zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    ]
    def getDataProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataProviderName", dataProviderName)
    def getDataProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataProviderArn", dataProviderArn)
    def getDataProviderCreationTime: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField(
        "dataProviderCreationTime",
        dataProviderCreationTime
      )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProvider
  ) extends zio.aws.databasemigration.model.DataProvider.ReadOnly {
    override val dataProviderName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataProviderName())
      .map(value => value: String)
    override val dataProviderArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataProviderArn())
      .map(value => value: String)
    override val dataProviderCreationTime: Optional[Iso8601DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataProviderCreationTime())
        .map(value =>
          zio.aws.databasemigration.model.primitives.Iso8601DateTime(value)
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val settings: Optional[
      zio.aws.databasemigration.model.DataProviderSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        zio.aws.databasemigration.model.DataProviderSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DataProvider
  ): zio.aws.databasemigration.model.DataProvider.ReadOnly = new Wrapper(impl)
}
