package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RunFleetAdvisorLsaAnalysisResponse(
    lsaAnalysisId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse = {
    import RunFleetAdvisorLsaAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse
      .builder()
      .optionallyWith(lsaAnalysisId.map(value => value: java.lang.String))(
        _.lsaAnalysisId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly =
    zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse
      .wrap(buildAwsValue())
}
object RunFleetAdvisorLsaAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse =
      zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse(
        lsaAnalysisId.map(value => value),
        status.map(value => value)
      )
    def lsaAnalysisId: Optional[String]
    def status: Optional[String]
    def getLsaAnalysisId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lsaAnalysisId", lsaAnalysisId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse
  ) extends zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly {
    override val lsaAnalysisId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lsaAnalysisId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse
  ): zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
