package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReloadReplicationTablesRequest(
    replicationConfigArn: String,
    tablesToReload: Iterable[zio.aws.databasemigration.model.TableToReload],
    reloadOption: Optional[zio.aws.databasemigration.model.ReloadOptionValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest = {
    import ReloadReplicationTablesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest
      .builder()
      .replicationConfigArn(replicationConfigArn: java.lang.String)
      .tablesToReload(tablesToReload.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(reloadOption.map(value => value.unwrap))(_.reloadOption)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReloadReplicationTablesRequest.ReadOnly =
    zio.aws.databasemigration.model.ReloadReplicationTablesRequest
      .wrap(buildAwsValue())
}
object ReloadReplicationTablesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReloadReplicationTablesRequest =
      zio.aws.databasemigration.model.ReloadReplicationTablesRequest(
        replicationConfigArn,
        tablesToReload.map { item =>
          item.asEditable
        },
        reloadOption.map(value => value)
      )
    def replicationConfigArn: String
    def tablesToReload
        : List[zio.aws.databasemigration.model.TableToReload.ReadOnly]
    def reloadOption
        : Optional[zio.aws.databasemigration.model.ReloadOptionValue]
    def getReplicationConfigArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationConfigArn)
    def getTablesToReload: ZIO[Any, Nothing, List[
      zio.aws.databasemigration.model.TableToReload.ReadOnly
    ]] = ZIO.succeed(tablesToReload)
    def getReloadOption: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReloadOptionValue
    ] = AwsError.unwrapOptionField("reloadOption", reloadOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest
  ) extends zio.aws.databasemigration.model.ReloadReplicationTablesRequest.ReadOnly {
    override val replicationConfigArn: String =
      impl.replicationConfigArn(): String
    override val tablesToReload
        : List[zio.aws.databasemigration.model.TableToReload.ReadOnly] = impl
      .tablesToReload()
      .asScala
      .map { item =>
        zio.aws.databasemigration.model.TableToReload.wrap(item)
      }
      .toList
    override val reloadOption
        : Optional[zio.aws.databasemigration.model.ReloadOptionValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reloadOption())
        .map(value =>
          zio.aws.databasemigration.model.ReloadOptionValue.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest
  ): zio.aws.databasemigration.model.ReloadReplicationTablesRequest.ReadOnly =
    new Wrapper(impl)
}
