package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationsResponse(
    marker: Optional[String] = Optional.Absent,
    replications: Optional[
      Iterable[zio.aws.databasemigration.model.Replication]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse = {
    import DescribeReplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replications)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationsResponse =
      zio.aws.databasemigration.model.DescribeReplicationsResponse(
        marker.map(value => value),
        replications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def replications
        : Optional[List[zio.aws.databasemigration.model.Replication.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplications: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Replication.ReadOnly
    ]] = AwsError.unwrapOptionField("replications", replications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val replications
        : Optional[List[zio.aws.databasemigration.model.Replication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Replication.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
