package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateReplicationInstanceRequest(
    replicationInstanceIdentifier: String,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    replicationInstanceClass: String,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    replicationSubnetGroupIdentifier: Optional[String] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    dnsNameServers: Optional[String] = Optional.Absent,
    resourceIdentifier: Optional[String] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest = {
    import CreateReplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
      .builder()
      .replicationInstanceIdentifier(
        replicationInstanceIdentifier: java.lang.String
      )
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .replicationInstanceClass(replicationInstanceClass: java.lang.String)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        replicationSubnetGroupIdentifier.map(value => value: java.lang.String)
      )(_.replicationSubnetGroupIdentifier)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(dnsNameServers.map(value => value: java.lang.String))(
        _.dnsNameServers
      )
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationInstanceRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationInstanceRequest
      .wrap(buildAwsValue())
}
object CreateReplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationInstanceRequest =
      zio.aws.databasemigration.model.CreateReplicationInstanceRequest(
        replicationInstanceIdentifier,
        allocatedStorage.map(value => value),
        replicationInstanceClass,
        vpcSecurityGroupIds.map(value => value),
        availabilityZone.map(value => value),
        replicationSubnetGroupIdentifier.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        publiclyAccessible.map(value => value),
        dnsNameServers.map(value => value),
        resourceIdentifier.map(value => value),
        networkType.map(value => value)
      )
    def replicationInstanceIdentifier: String
    def allocatedStorage: Optional[IntegerOptional]
    def replicationInstanceClass: String
    def vpcSecurityGroupIds: Optional[List[String]]
    def availabilityZone: Optional[String]
    def replicationSubnetGroupIdentifier: Optional[String]
    def preferredMaintenanceWindow: Optional[String]
    def multiAZ: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def kmsKeyId: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def dnsNameServers: Optional[String]
    def resourceIdentifier: Optional[String]
    def networkType: Optional[String]
    def getReplicationInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceIdentifier)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getReplicationInstanceClass: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceClass)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getReplicationSubnetGroupIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationSubnetGroupIdentifier",
        replicationSubnetGroupIdentifier
      )
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getDnsNameServers: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsNameServers", dnsNameServers)
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
  ) extends zio.aws.databasemigration.model.CreateReplicationInstanceRequest.ReadOnly {
    override val replicationInstanceIdentifier: String =
      impl.replicationInstanceIdentifier(): String
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val replicationInstanceClass: String =
      impl.replicationInstanceClass(): String
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val replicationSubnetGroupIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationSubnetGroupIdentifier())
        .map(value => value: String)
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val dnsNameServers: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsNameServers())
      .map(value => value: String)
    override val resourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifier())
      .map(value => value: String)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest
  ): zio.aws.databasemigration.model.CreateReplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
