package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelReplicationTaskAssessmentRunResponse(
    replicationTaskAssessmentRun: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse = {
    import CancelReplicationTaskAssessmentRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse
      .builder()
      .optionallyWith(
        replicationTaskAssessmentRun.map(value => value.buildAwsValue())
      )(_.replicationTaskAssessmentRun)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly =
    zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse
      .wrap(buildAwsValue())
}
object CancelReplicationTaskAssessmentRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse =
      zio.aws.databasemigration.model
        .CancelReplicationTaskAssessmentRunResponse(
          replicationTaskAssessmentRun.map(value => value.asEditable)
        )
    def replicationTaskAssessmentRun: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]
    def getReplicationTaskAssessmentRun: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationTaskAssessmentRun",
      replicationTaskAssessmentRun
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse
  ) extends zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly {
    override val replicationTaskAssessmentRun: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskAssessmentRun())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse
  ): zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly =
    new Wrapper(impl)
}
