package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationTableStatisticsResponse(
    replicationConfigArn: Optional[String] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    replicationTableStatistics: Optional[
      Iterable[zio.aws.databasemigration.model.TableStatistics]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse = {
    import DescribeReplicationTableStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse
      .builder()
      .optionallyWith(
        replicationConfigArn.map(value => value: java.lang.String)
      )(_.replicationConfigArn)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationTableStatistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationTableStatistics)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationTableStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse =
      zio.aws.databasemigration.model
        .DescribeReplicationTableStatisticsResponse(
          replicationConfigArn.map(value => value),
          marker.map(value => value),
          replicationTableStatistics.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def replicationConfigArn: Optional[String]
    def marker: Optional[String]
    def replicationTableStatistics: Optional[
      List[zio.aws.databasemigration.model.TableStatistics.ReadOnly]
    ]
    def getReplicationConfigArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationConfigArn", replicationConfigArn)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationTableStatistics: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.TableStatistics.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationTableStatistics",
      replicationTableStatistics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly {
    override val replicationConfigArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationConfigArn())
      .map(value => value: String)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val replicationTableStatistics: Optional[
      List[zio.aws.databasemigration.model.TableStatistics.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTableStatistics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.TableStatistics.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationTableStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
