package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait LongVarcharMappingType {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType
}
object LongVarcharMappingType {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType
  ): zio.aws.databasemigration.model.LongVarcharMappingType = value match {
    case software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.WSTRING =>
      val r = wstring
      r
    case software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.CLOB =>
      val r = clob
      r
    case software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.NCLOB =>
      val r = nclob
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.LongVarcharMappingType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType =
      software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.UNKNOWN_TO_SDK_VERSION
  }
  case object wstring
      extends zio.aws.databasemigration.model.LongVarcharMappingType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType =
      software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.WSTRING
  }
  case object clob
      extends zio.aws.databasemigration.model.LongVarcharMappingType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType =
      software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.CLOB
  }
  case object nclob
      extends zio.aws.databasemigration.model.LongVarcharMappingType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType =
      software.amazon.awssdk.services.databasemigration.model.LongVarcharMappingType.NCLOB
  }
}
