package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait SafeguardPolicy {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy
}
object SafeguardPolicy {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy
  ): zio.aws.databasemigration.model.SafeguardPolicy = value match {
    case software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.RELY_ON_SQL_SERVER_REPLICATION_AGENT =>
      val r = `rely-on-sql-server-replication-agent`
      r
    case software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.EXCLUSIVE_AUTOMATIC_TRUNCATION =>
      val r = `exclusive-automatic-truncation`
      r
    case software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.SHARED_AUTOMATIC_TRUNCATION =>
      val r = `shared-automatic-truncation`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.SafeguardPolicy {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy =
      software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object `rely-on-sql-server-replication-agent`
      extends zio.aws.databasemigration.model.SafeguardPolicy {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy =
      software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.RELY_ON_SQL_SERVER_REPLICATION_AGENT
  }
  case object `exclusive-automatic-truncation`
      extends zio.aws.databasemigration.model.SafeguardPolicy {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy =
      software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.EXCLUSIVE_AUTOMATIC_TRUNCATION
  }
  case object `shared-automatic-truncation`
      extends zio.aws.databasemigration.model.SafeguardPolicy {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy =
      software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy.SHARED_AUTOMATIC_TRUNCATION
  }
}
