package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventSubscription(
    customerAwsId: Optional[String] = Optional.Absent,
    custSubscriptionId: Optional[String] = Optional.Absent,
    snsTopicArn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    subscriptionCreationTime: Optional[String] = Optional.Absent,
    sourceType: Optional[String] = Optional.Absent,
    sourceIdsList: Optional[Iterable[String]] = Optional.Absent,
    eventCategoriesList: Optional[Iterable[String]] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.EventSubscription = {
    import EventSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.EventSubscription
      .builder()
      .optionallyWith(customerAwsId.map(value => value: java.lang.String))(
        _.customerAwsId
      )
      .optionallyWith(custSubscriptionId.map(value => value: java.lang.String))(
        _.custSubscriptionId
      )
      .optionallyWith(snsTopicArn.map(value => value: java.lang.String))(
        _.snsTopicArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        subscriptionCreationTime.map(value => value: java.lang.String)
      )(_.subscriptionCreationTime)
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        sourceIdsList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIdsList)
      .optionallyWith(
        eventCategoriesList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategoriesList)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.EventSubscription.ReadOnly =
    zio.aws.databasemigration.model.EventSubscription.wrap(buildAwsValue())
}
object EventSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.EventSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.EventSubscription =
      zio.aws.databasemigration.model.EventSubscription(
        customerAwsId.map(value => value),
        custSubscriptionId.map(value => value),
        snsTopicArn.map(value => value),
        status.map(value => value),
        subscriptionCreationTime.map(value => value),
        sourceType.map(value => value),
        sourceIdsList.map(value => value),
        eventCategoriesList.map(value => value),
        enabled.map(value => value)
      )
    def customerAwsId: Optional[String]
    def custSubscriptionId: Optional[String]
    def snsTopicArn: Optional[String]
    def status: Optional[String]
    def subscriptionCreationTime: Optional[String]
    def sourceType: Optional[String]
    def sourceIdsList: Optional[List[String]]
    def eventCategoriesList: Optional[List[String]]
    def enabled: Optional[Boolean]
    def getCustomerAwsId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerAwsId", customerAwsId)
    def getCustSubscriptionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionId)
    def getSnsTopicArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionCreationTime: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("subscriptionCreationTime", subscriptionCreationTime)
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getSourceIdsList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sourceIdsList", sourceIdsList)
    def getEventCategoriesList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesList)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.EventSubscription
  ) extends zio.aws.databasemigration.model.EventSubscription.ReadOnly {
    override val customerAwsId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerAwsId())
      .map(value => value: String)
    override val custSubscriptionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.custSubscriptionId())
      .map(value => value: String)
    override val snsTopicArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopicArn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val subscriptionCreationTime: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptionCreationTime())
        .map(value => value: String)
    override val sourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => value: String)
    override val sourceIdsList: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIdsList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val eventCategoriesList: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCategoriesList())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.EventSubscription
  ): zio.aws.databasemigration.model.EventSubscription.ReadOnly = new Wrapper(
    impl
  )
}
