package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecommendationData(
    rdsEngine: Optional[zio.aws.databasemigration.model.RdsRecommendation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RecommendationData = {
    import RecommendationData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RecommendationData
      .builder()
      .optionallyWith(rdsEngine.map(value => value.buildAwsValue()))(
        _.rdsEngine
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.RecommendationData.ReadOnly =
    zio.aws.databasemigration.model.RecommendationData.wrap(buildAwsValue())
}
object RecommendationData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RecommendationData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RecommendationData =
      zio.aws.databasemigration.model
        .RecommendationData(rdsEngine.map(value => value.asEditable))
    def rdsEngine
        : Optional[zio.aws.databasemigration.model.RdsRecommendation.ReadOnly]
    def getRdsEngine: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RdsRecommendation.ReadOnly
    ] = AwsError.unwrapOptionField("rdsEngine", rdsEngine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RecommendationData
  ) extends zio.aws.databasemigration.model.RecommendationData.ReadOnly {
    override val rdsEngine
        : Optional[zio.aws.databasemigration.model.RdsRecommendation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rdsEngine())
        .map(value =>
          zio.aws.databasemigration.model.RdsRecommendation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RecommendationData
  ): zio.aws.databasemigration.model.RecommendationData.ReadOnly = new Wrapper(
    impl
  )
}
