package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class RebootReplicationInstanceRequest(
    replicationInstanceArn: String,
    forceFailover: Optional[BooleanOptional] = Optional.Absent,
    forcePlannedFailover: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest = {
    import RebootReplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .optionallyWith(forceFailover.map(value => value: java.lang.Boolean))(
        _.forceFailover
      )
      .optionallyWith(
        forcePlannedFailover.map(value => value: java.lang.Boolean)
      )(_.forcePlannedFailover)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RebootReplicationInstanceRequest.ReadOnly =
    zio.aws.databasemigration.model.RebootReplicationInstanceRequest
      .wrap(buildAwsValue())
}
object RebootReplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.RebootReplicationInstanceRequest =
      zio.aws.databasemigration.model.RebootReplicationInstanceRequest(
        replicationInstanceArn,
        forceFailover.map(value => value),
        forcePlannedFailover.map(value => value)
      )
    def replicationInstanceArn: String
    def forceFailover: Optional[BooleanOptional]
    def forcePlannedFailover: Optional[BooleanOptional]
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getForceFailover: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("forceFailover", forceFailover)
    def getForcePlannedFailover: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("forcePlannedFailover", forcePlannedFailover)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest
  ) extends zio.aws.databasemigration.model.RebootReplicationInstanceRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val forceFailover: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceFailover())
        .map(value => value: BooleanOptional)
    override val forcePlannedFailover: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forcePlannedFailover())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest
  ): zio.aws.databasemigration.model.RebootReplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
