package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class S3Settings(
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    externalTableDefinition: Optional[String] = Optional.Absent,
    csvRowDelimiter: Optional[String] = Optional.Absent,
    csvDelimiter: Optional[String] = Optional.Absent,
    bucketFolder: Optional[String] = Optional.Absent,
    bucketName: Optional[String] = Optional.Absent,
    compressionType: Optional[
      zio.aws.databasemigration.model.CompressionTypeValue
    ] = Optional.Absent,
    encryptionMode: Optional[
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = Optional.Absent,
    serverSideEncryptionKmsKeyId: Optional[String] = Optional.Absent,
    dataFormat: Optional[zio.aws.databasemigration.model.DataFormatValue] =
      Optional.Absent,
    encodingType: Optional[zio.aws.databasemigration.model.EncodingTypeValue] =
      Optional.Absent,
    dictPageSizeLimit: Optional[IntegerOptional] = Optional.Absent,
    rowGroupLength: Optional[IntegerOptional] = Optional.Absent,
    dataPageSize: Optional[IntegerOptional] = Optional.Absent,
    parquetVersion: Optional[
      zio.aws.databasemigration.model.ParquetVersionValue
    ] = Optional.Absent,
    enableStatistics: Optional[BooleanOptional] = Optional.Absent,
    includeOpForFullLoad: Optional[BooleanOptional] = Optional.Absent,
    cdcInsertsOnly: Optional[BooleanOptional] = Optional.Absent,
    timestampColumnName: Optional[String] = Optional.Absent,
    parquetTimestampInMillisecond: Optional[BooleanOptional] = Optional.Absent,
    cdcInsertsAndUpdates: Optional[BooleanOptional] = Optional.Absent,
    datePartitionEnabled: Optional[BooleanOptional] = Optional.Absent,
    datePartitionSequence: Optional[
      zio.aws.databasemigration.model.DatePartitionSequenceValue
    ] = Optional.Absent,
    datePartitionDelimiter: Optional[
      zio.aws.databasemigration.model.DatePartitionDelimiterValue
    ] = Optional.Absent,
    useCsvNoSupValue: Optional[BooleanOptional] = Optional.Absent,
    csvNoSupValue: Optional[String] = Optional.Absent,
    preserveTransactions: Optional[BooleanOptional] = Optional.Absent,
    cdcPath: Optional[String] = Optional.Absent,
    useTaskStartTimeForFullLoadTimestamp: Optional[BooleanOptional] =
      Optional.Absent,
    cannedAclForObjects: Optional[
      zio.aws.databasemigration.model.CannedAclForObjectsValue
    ] = Optional.Absent,
    addColumnName: Optional[BooleanOptional] = Optional.Absent,
    cdcMaxBatchInterval: Optional[IntegerOptional] = Optional.Absent,
    cdcMinFileSize: Optional[IntegerOptional] = Optional.Absent,
    csvNullValue: Optional[String] = Optional.Absent,
    ignoreHeaderRows: Optional[IntegerOptional] = Optional.Absent,
    maxFileSize: Optional[IntegerOptional] = Optional.Absent,
    rfc4180: Optional[BooleanOptional] = Optional.Absent,
    datePartitionTimezone: Optional[String] = Optional.Absent,
    addTrailingPaddingCharacter: Optional[BooleanOptional] = Optional.Absent,
    expectedBucketOwner: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.S3Settings = {
    import S3Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.S3Settings
      .builder()
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        externalTableDefinition.map(value => value: java.lang.String)
      )(_.externalTableDefinition)
      .optionallyWith(csvRowDelimiter.map(value => value: java.lang.String))(
        _.csvRowDelimiter
      )
      .optionallyWith(csvDelimiter.map(value => value: java.lang.String))(
        _.csvDelimiter
      )
      .optionallyWith(bucketFolder.map(value => value: java.lang.String))(
        _.bucketFolder
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .optionallyWith(
        serverSideEncryptionKmsKeyId.map(value => value: java.lang.String)
      )(_.serverSideEncryptionKmsKeyId)
      .optionallyWith(dataFormat.map(value => value.unwrap))(_.dataFormat)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(dictPageSizeLimit.map(value => value: Integer))(
        _.dictPageSizeLimit
      )
      .optionallyWith(rowGroupLength.map(value => value: Integer))(
        _.rowGroupLength
      )
      .optionallyWith(dataPageSize.map(value => value: Integer))(_.dataPageSize)
      .optionallyWith(parquetVersion.map(value => value.unwrap))(
        _.parquetVersion
      )
      .optionallyWith(enableStatistics.map(value => value: java.lang.Boolean))(
        _.enableStatistics
      )
      .optionallyWith(
        includeOpForFullLoad.map(value => value: java.lang.Boolean)
      )(_.includeOpForFullLoad)
      .optionallyWith(cdcInsertsOnly.map(value => value: java.lang.Boolean))(
        _.cdcInsertsOnly
      )
      .optionallyWith(
        timestampColumnName.map(value => value: java.lang.String)
      )(_.timestampColumnName)
      .optionallyWith(
        parquetTimestampInMillisecond.map(value => value: java.lang.Boolean)
      )(_.parquetTimestampInMillisecond)
      .optionallyWith(
        cdcInsertsAndUpdates.map(value => value: java.lang.Boolean)
      )(_.cdcInsertsAndUpdates)
      .optionallyWith(
        datePartitionEnabled.map(value => value: java.lang.Boolean)
      )(_.datePartitionEnabled)
      .optionallyWith(datePartitionSequence.map(value => value.unwrap))(
        _.datePartitionSequence
      )
      .optionallyWith(datePartitionDelimiter.map(value => value.unwrap))(
        _.datePartitionDelimiter
      )
      .optionallyWith(useCsvNoSupValue.map(value => value: java.lang.Boolean))(
        _.useCsvNoSupValue
      )
      .optionallyWith(csvNoSupValue.map(value => value: java.lang.String))(
        _.csvNoSupValue
      )
      .optionallyWith(
        preserveTransactions.map(value => value: java.lang.Boolean)
      )(_.preserveTransactions)
      .optionallyWith(cdcPath.map(value => value: java.lang.String))(_.cdcPath)
      .optionallyWith(
        useTaskStartTimeForFullLoadTimestamp.map(value =>
          value: java.lang.Boolean
        )
      )(_.useTaskStartTimeForFullLoadTimestamp)
      .optionallyWith(cannedAclForObjects.map(value => value.unwrap))(
        _.cannedAclForObjects
      )
      .optionallyWith(addColumnName.map(value => value: java.lang.Boolean))(
        _.addColumnName
      )
      .optionallyWith(cdcMaxBatchInterval.map(value => value: Integer))(
        _.cdcMaxBatchInterval
      )
      .optionallyWith(cdcMinFileSize.map(value => value: Integer))(
        _.cdcMinFileSize
      )
      .optionallyWith(csvNullValue.map(value => value: java.lang.String))(
        _.csvNullValue
      )
      .optionallyWith(ignoreHeaderRows.map(value => value: Integer))(
        _.ignoreHeaderRows
      )
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(rfc4180.map(value => value: java.lang.Boolean))(_.rfc4180)
      .optionallyWith(
        datePartitionTimezone.map(value => value: java.lang.String)
      )(_.datePartitionTimezone)
      .optionallyWith(
        addTrailingPaddingCharacter.map(value => value: java.lang.Boolean)
      )(_.addTrailingPaddingCharacter)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.S3Settings.ReadOnly =
    zio.aws.databasemigration.model.S3Settings.wrap(buildAwsValue())
}
object S3Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.S3Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.S3Settings =
      zio.aws.databasemigration.model.S3Settings(
        serviceAccessRoleArn.map(value => value),
        externalTableDefinition.map(value => value),
        csvRowDelimiter.map(value => value),
        csvDelimiter.map(value => value),
        bucketFolder.map(value => value),
        bucketName.map(value => value),
        compressionType.map(value => value),
        encryptionMode.map(value => value),
        serverSideEncryptionKmsKeyId.map(value => value),
        dataFormat.map(value => value),
        encodingType.map(value => value),
        dictPageSizeLimit.map(value => value),
        rowGroupLength.map(value => value),
        dataPageSize.map(value => value),
        parquetVersion.map(value => value),
        enableStatistics.map(value => value),
        includeOpForFullLoad.map(value => value),
        cdcInsertsOnly.map(value => value),
        timestampColumnName.map(value => value),
        parquetTimestampInMillisecond.map(value => value),
        cdcInsertsAndUpdates.map(value => value),
        datePartitionEnabled.map(value => value),
        datePartitionSequence.map(value => value),
        datePartitionDelimiter.map(value => value),
        useCsvNoSupValue.map(value => value),
        csvNoSupValue.map(value => value),
        preserveTransactions.map(value => value),
        cdcPath.map(value => value),
        useTaskStartTimeForFullLoadTimestamp.map(value => value),
        cannedAclForObjects.map(value => value),
        addColumnName.map(value => value),
        cdcMaxBatchInterval.map(value => value),
        cdcMinFileSize.map(value => value),
        csvNullValue.map(value => value),
        ignoreHeaderRows.map(value => value),
        maxFileSize.map(value => value),
        rfc4180.map(value => value),
        datePartitionTimezone.map(value => value),
        addTrailingPaddingCharacter.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def serviceAccessRoleArn: Optional[String]
    def externalTableDefinition: Optional[String]
    def csvRowDelimiter: Optional[String]
    def csvDelimiter: Optional[String]
    def bucketFolder: Optional[String]
    def bucketName: Optional[String]
    def compressionType
        : Optional[zio.aws.databasemigration.model.CompressionTypeValue]
    def encryptionMode
        : Optional[zio.aws.databasemigration.model.EncryptionModeValue]
    def serverSideEncryptionKmsKeyId: Optional[String]
    def dataFormat: Optional[zio.aws.databasemigration.model.DataFormatValue]
    def encodingType
        : Optional[zio.aws.databasemigration.model.EncodingTypeValue]
    def dictPageSizeLimit: Optional[IntegerOptional]
    def rowGroupLength: Optional[IntegerOptional]
    def dataPageSize: Optional[IntegerOptional]
    def parquetVersion
        : Optional[zio.aws.databasemigration.model.ParquetVersionValue]
    def enableStatistics: Optional[BooleanOptional]
    def includeOpForFullLoad: Optional[BooleanOptional]
    def cdcInsertsOnly: Optional[BooleanOptional]
    def timestampColumnName: Optional[String]
    def parquetTimestampInMillisecond: Optional[BooleanOptional]
    def cdcInsertsAndUpdates: Optional[BooleanOptional]
    def datePartitionEnabled: Optional[BooleanOptional]
    def datePartitionSequence
        : Optional[zio.aws.databasemigration.model.DatePartitionSequenceValue]
    def datePartitionDelimiter
        : Optional[zio.aws.databasemigration.model.DatePartitionDelimiterValue]
    def useCsvNoSupValue: Optional[BooleanOptional]
    def csvNoSupValue: Optional[String]
    def preserveTransactions: Optional[BooleanOptional]
    def cdcPath: Optional[String]
    def useTaskStartTimeForFullLoadTimestamp: Optional[BooleanOptional]
    def cannedAclForObjects
        : Optional[zio.aws.databasemigration.model.CannedAclForObjectsValue]
    def addColumnName: Optional[BooleanOptional]
    def cdcMaxBatchInterval: Optional[IntegerOptional]
    def cdcMinFileSize: Optional[IntegerOptional]
    def csvNullValue: Optional[String]
    def ignoreHeaderRows: Optional[IntegerOptional]
    def maxFileSize: Optional[IntegerOptional]
    def rfc4180: Optional[BooleanOptional]
    def datePartitionTimezone: Optional[String]
    def addTrailingPaddingCharacter: Optional[BooleanOptional]
    def expectedBucketOwner: Optional[String]
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getExternalTableDefinition: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("externalTableDefinition", externalTableDefinition)
    def getCsvRowDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvRowDelimiter", csvRowDelimiter)
    def getCsvDelimiter: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvDelimiter", csvDelimiter)
    def getBucketFolder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketFolder", bucketFolder)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getCompressionType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CompressionTypeValue
    ] = AwsError.unwrapOptionField("compressionType", compressionType)
    def getEncryptionMode: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getServerSideEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "serverSideEncryptionKmsKeyId",
        serverSideEncryptionKmsKeyId
      )
    def getDataFormat
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DataFormatValue] =
      AwsError.unwrapOptionField("dataFormat", dataFormat)
    def getEncodingType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EncodingTypeValue
    ] = AwsError.unwrapOptionField("encodingType", encodingType)
    def getDictPageSizeLimit: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("dictPageSizeLimit", dictPageSizeLimit)
    def getRowGroupLength: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("rowGroupLength", rowGroupLength)
    def getDataPageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("dataPageSize", dataPageSize)
    def getParquetVersion: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ParquetVersionValue
    ] = AwsError.unwrapOptionField("parquetVersion", parquetVersion)
    def getEnableStatistics: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableStatistics", enableStatistics)
    def getIncludeOpForFullLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeOpForFullLoad", includeOpForFullLoad)
    def getCdcInsertsOnly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("cdcInsertsOnly", cdcInsertsOnly)
    def getTimestampColumnName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timestampColumnName", timestampColumnName)
    def getParquetTimestampInMillisecond: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "parquetTimestampInMillisecond",
        parquetTimestampInMillisecond
      )
    def getCdcInsertsAndUpdates: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("cdcInsertsAndUpdates", cdcInsertsAndUpdates)
    def getDatePartitionEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("datePartitionEnabled", datePartitionEnabled)
    def getDatePartitionSequence: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatePartitionSequenceValue
    ] =
      AwsError.unwrapOptionField("datePartitionSequence", datePartitionSequence)
    def getDatePartitionDelimiter: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatePartitionDelimiterValue
    ] = AwsError.unwrapOptionField(
      "datePartitionDelimiter",
      datePartitionDelimiter
    )
    def getUseCsvNoSupValue: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useCsvNoSupValue", useCsvNoSupValue)
    def getCsvNoSupValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvNoSupValue", csvNoSupValue)
    def getPreserveTransactions: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("preserveTransactions", preserveTransactions)
    def getCdcPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcPath", cdcPath)
    def getUseTaskStartTimeForFullLoadTimestamp
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "useTaskStartTimeForFullLoadTimestamp",
      useTaskStartTimeForFullLoadTimestamp
    )
    def getCannedAclForObjects: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CannedAclForObjectsValue
    ] = AwsError.unwrapOptionField("cannedAclForObjects", cannedAclForObjects)
    def getAddColumnName: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("addColumnName", addColumnName)
    def getCdcMaxBatchInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("cdcMaxBatchInterval", cdcMaxBatchInterval)
    def getCdcMinFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("cdcMinFileSize", cdcMinFileSize)
    def getCsvNullValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("csvNullValue", csvNullValue)
    def getIgnoreHeaderRows: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("ignoreHeaderRows", ignoreHeaderRows)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getRfc4180: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("rfc4180", rfc4180)
    def getDatePartitionTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("datePartitionTimezone", datePartitionTimezone)
    def getAddTrailingPaddingCharacter: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "addTrailingPaddingCharacter",
        addTrailingPaddingCharacter
      )
    def getExpectedBucketOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.S3Settings
  ) extends zio.aws.databasemigration.model.S3Settings.ReadOnly {
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val externalTableDefinition: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalTableDefinition())
        .map(value => value: String)
    override val csvRowDelimiter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.csvRowDelimiter())
      .map(value => value: String)
    override val csvDelimiter: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.csvDelimiter())
      .map(value => value: String)
    override val bucketFolder: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketFolder())
      .map(value => value: String)
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val compressionType
        : Optional[zio.aws.databasemigration.model.CompressionTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionType())
        .map(value =>
          zio.aws.databasemigration.model.CompressionTypeValue.wrap(value)
        )
    override val encryptionMode
        : Optional[zio.aws.databasemigration.model.EncryptionModeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value =>
          zio.aws.databasemigration.model.EncryptionModeValue.wrap(value)
        )
    override val serverSideEncryptionKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryptionKmsKeyId())
        .map(value => value: String)
    override val dataFormat
        : Optional[zio.aws.databasemigration.model.DataFormatValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataFormat())
        .map(value =>
          zio.aws.databasemigration.model.DataFormatValue.wrap(value)
        )
    override val encodingType
        : Optional[zio.aws.databasemigration.model.EncodingTypeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value =>
          zio.aws.databasemigration.model.EncodingTypeValue.wrap(value)
        )
    override val dictPageSizeLimit: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dictPageSizeLimit())
        .map(value => value: IntegerOptional)
    override val rowGroupLength: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rowGroupLength())
        .map(value => value: IntegerOptional)
    override val dataPageSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPageSize())
      .map(value => value: IntegerOptional)
    override val parquetVersion
        : Optional[zio.aws.databasemigration.model.ParquetVersionValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parquetVersion())
        .map(value =>
          zio.aws.databasemigration.model.ParquetVersionValue.wrap(value)
        )
    override val enableStatistics: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableStatistics())
        .map(value => value: BooleanOptional)
    override val includeOpForFullLoad: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeOpForFullLoad())
        .map(value => value: BooleanOptional)
    override val cdcInsertsOnly: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdcInsertsOnly())
        .map(value => value: BooleanOptional)
    override val timestampColumnName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timestampColumnName())
      .map(value => value: String)
    override val parquetTimestampInMillisecond: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parquetTimestampInMillisecond())
        .map(value => value: BooleanOptional)
    override val cdcInsertsAndUpdates: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdcInsertsAndUpdates())
        .map(value => value: BooleanOptional)
    override val datePartitionEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datePartitionEnabled())
        .map(value => value: BooleanOptional)
    override val datePartitionSequence
        : Optional[zio.aws.databasemigration.model.DatePartitionSequenceValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datePartitionSequence())
        .map(value =>
          zio.aws.databasemigration.model.DatePartitionSequenceValue.wrap(value)
        )
    override val datePartitionDelimiter: Optional[
      zio.aws.databasemigration.model.DatePartitionDelimiterValue
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.datePartitionDelimiter())
      .map(value =>
        zio.aws.databasemigration.model.DatePartitionDelimiterValue.wrap(value)
      )
    override val useCsvNoSupValue: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useCsvNoSupValue())
        .map(value => value: BooleanOptional)
    override val csvNoSupValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.csvNoSupValue())
      .map(value => value: String)
    override val preserveTransactions: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preserveTransactions())
        .map(value => value: BooleanOptional)
    override val cdcPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcPath())
      .map(value => value: String)
    override val useTaskStartTimeForFullLoadTimestamp
        : Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.useTaskStartTimeForFullLoadTimestamp())
      .map(value => value: BooleanOptional)
    override val cannedAclForObjects
        : Optional[zio.aws.databasemigration.model.CannedAclForObjectsValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cannedAclForObjects())
        .map(value =>
          zio.aws.databasemigration.model.CannedAclForObjectsValue.wrap(value)
        )
    override val addColumnName: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addColumnName())
        .map(value => value: BooleanOptional)
    override val cdcMaxBatchInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdcMaxBatchInterval())
        .map(value => value: IntegerOptional)
    override val cdcMinFileSize: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cdcMinFileSize())
        .map(value => value: IntegerOptional)
    override val csvNullValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.csvNullValue())
      .map(value => value: String)
    override val ignoreHeaderRows: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ignoreHeaderRows())
        .map(value => value: IntegerOptional)
    override val maxFileSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFileSize())
      .map(value => value: IntegerOptional)
    override val rfc4180: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.rfc4180())
      .map(value => value: BooleanOptional)
    override val datePartitionTimezone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.datePartitionTimezone())
      .map(value => value: String)
    override val addTrailingPaddingCharacter: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addTrailingPaddingCharacter())
        .map(value => value: BooleanOptional)
    override val expectedBucketOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.expectedBucketOwner())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.S3Settings
  ): zio.aws.databasemigration.model.S3Settings.ReadOnly = new Wrapper(impl)
}
