package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MoveReplicationTaskRequest(
    replicationTaskArn: String,
    targetReplicationInstanceArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest = {
    import MoveReplicationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest
      .builder()
      .replicationTaskArn(replicationTaskArn: java.lang.String)
      .targetReplicationInstanceArn(
        targetReplicationInstanceArn: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.MoveReplicationTaskRequest.ReadOnly =
    zio.aws.databasemigration.model.MoveReplicationTaskRequest
      .wrap(buildAwsValue())
}
object MoveReplicationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MoveReplicationTaskRequest =
      zio.aws.databasemigration.model.MoveReplicationTaskRequest(
        replicationTaskArn,
        targetReplicationInstanceArn
      )
    def replicationTaskArn: String
    def targetReplicationInstanceArn: String
    def getReplicationTaskArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskArn)
    def getTargetReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetReplicationInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest
  ) extends zio.aws.databasemigration.model.MoveReplicationTaskRequest.ReadOnly {
    override val replicationTaskArn: String = impl.replicationTaskArn(): String
    override val targetReplicationInstanceArn: String =
      impl.targetReplicationInstanceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest
  ): zio.aws.databasemigration.model.MoveReplicationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
