package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationTaskAssessmentRunsResponse(
    marker: Optional[String] = Optional.Absent,
    replicationTaskAssessmentRuns: Optional[
      Iterable[zio.aws.databasemigration.model.ReplicationTaskAssessmentRun]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse = {
    import DescribeReplicationTaskAssessmentRunsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationTaskAssessmentRuns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationTaskAssessmentRuns)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationTaskAssessmentRunsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse =
      zio.aws.databasemigration.model
        .DescribeReplicationTaskAssessmentRunsResponse(
          marker.map(value => value),
          replicationTaskAssessmentRuns.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def marker: Optional[String]
    def replicationTaskAssessmentRuns: Optional[List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationTaskAssessmentRuns: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "replicationTaskAssessmentRuns",
      replicationTaskAssessmentRuns
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val replicationTaskAssessmentRuns: Optional[List[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskAssessmentRuns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationTaskAssessmentRun
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse
  ): zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly =
    new Wrapper(impl)
}
