package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeSchemasRequest(
    endpointArn: String,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest = {
    import DescribeSchemasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeSchemasRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeSchemasRequest.wrap(buildAwsValue())
}
object DescribeSchemasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DescribeSchemasRequest =
      zio.aws.databasemigration.model.DescribeSchemasRequest(
        endpointArn,
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def endpointArn: String
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest
  ) extends zio.aws.databasemigration.model.DescribeSchemasRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest
  ): zio.aws.databasemigration.model.DescribeSchemasRequest.ReadOnly =
    new Wrapper(impl)
}
