package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait AuthTypeValue {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.AuthTypeValue
}
object AuthTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.AuthTypeValue
  ): zio.aws.databasemigration.model.AuthTypeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.AuthTypeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.AuthTypeValue.NO =>
      val r = no
      r
    case software.amazon.awssdk.services.databasemigration.model.AuthTypeValue.PASSWORD =>
      val r = password
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.AuthTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AuthTypeValue =
      software.amazon.awssdk.services.databasemigration.model.AuthTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object no extends zio.aws.databasemigration.model.AuthTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AuthTypeValue =
      software.amazon.awssdk.services.databasemigration.model.AuthTypeValue.NO
  }
  case object password extends zio.aws.databasemigration.model.AuthTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AuthTypeValue =
      software.amazon.awssdk.services.databasemigration.model.AuthTypeValue.PASSWORD
  }
}
