package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DatabaseInstanceSoftwareDetailsResponse(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    engineEdition: Optional[String] = Optional.Absent,
    servicePack: Optional[String] = Optional.Absent,
    supportLevel: Optional[String] = Optional.Absent,
    osArchitecture: Optional[IntegerOptional] = Optional.Absent,
    tooltip: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse = {
    import DatabaseInstanceSoftwareDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(engineEdition.map(value => value: java.lang.String))(
        _.engineEdition
      )
      .optionallyWith(servicePack.map(value => value: java.lang.String))(
        _.servicePack
      )
      .optionallyWith(supportLevel.map(value => value: java.lang.String))(
        _.supportLevel
      )
      .optionallyWith(osArchitecture.map(value => value: Integer))(
        _.osArchitecture
      )
      .optionallyWith(tooltip.map(value => value: java.lang.String))(_.tooltip)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse.ReadOnly =
    zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse
      .wrap(buildAwsValue())
}
object DatabaseInstanceSoftwareDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse =
      zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse(
        engine.map(value => value),
        engineVersion.map(value => value),
        engineEdition.map(value => value),
        servicePack.map(value => value),
        supportLevel.map(value => value),
        osArchitecture.map(value => value),
        tooltip.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def engineEdition: Optional[String]
    def servicePack: Optional[String]
    def supportLevel: Optional[String]
    def osArchitecture: Optional[IntegerOptional]
    def tooltip: Optional[String]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEngineEdition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineEdition", engineEdition)
    def getServicePack: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("servicePack", servicePack)
    def getSupportLevel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportLevel", supportLevel)
    def getOsArchitecture: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("osArchitecture", osArchitecture)
    def getTooltip: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tooltip", tooltip)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse
  ) extends zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val engineEdition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineEdition())
      .map(value => value: String)
    override val servicePack: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.servicePack())
      .map(value => value: String)
    override val supportLevel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportLevel())
      .map(value => value: String)
    override val osArchitecture: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.osArchitecture())
        .map(value => value: IntegerOptional)
    override val tooltip: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tooltip())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse
  ): zio.aws.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
