package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{BooleanOptional, TStamp}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TableStatistics(
    schemaName: Optional[String] = Optional.Absent,
    tableName: Optional[String] = Optional.Absent,
    inserts: Optional[Long] = Optional.Absent,
    deletes: Optional[Long] = Optional.Absent,
    updates: Optional[Long] = Optional.Absent,
    ddls: Optional[Long] = Optional.Absent,
    fullLoadRows: Optional[Long] = Optional.Absent,
    fullLoadCondtnlChkFailedRows: Optional[Long] = Optional.Absent,
    fullLoadErrorRows: Optional[Long] = Optional.Absent,
    fullLoadStartTime: Optional[TStamp] = Optional.Absent,
    fullLoadEndTime: Optional[TStamp] = Optional.Absent,
    fullLoadReloaded: Optional[BooleanOptional] = Optional.Absent,
    lastUpdateTime: Optional[TStamp] = Optional.Absent,
    tableState: Optional[String] = Optional.Absent,
    validationPendingRecords: Optional[Long] = Optional.Absent,
    validationFailedRecords: Optional[Long] = Optional.Absent,
    validationSuspendedRecords: Optional[Long] = Optional.Absent,
    validationState: Optional[String] = Optional.Absent,
    validationStateDetails: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.TableStatistics = {
    import TableStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.TableStatistics
      .builder()
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .optionallyWith(inserts.map(value => value: java.lang.Long))(_.inserts)
      .optionallyWith(deletes.map(value => value: java.lang.Long))(_.deletes)
      .optionallyWith(updates.map(value => value: java.lang.Long))(_.updates)
      .optionallyWith(ddls.map(value => value: java.lang.Long))(_.ddls)
      .optionallyWith(fullLoadRows.map(value => value: java.lang.Long))(
        _.fullLoadRows
      )
      .optionallyWith(
        fullLoadCondtnlChkFailedRows.map(value => value: java.lang.Long)
      )(_.fullLoadCondtnlChkFailedRows)
      .optionallyWith(fullLoadErrorRows.map(value => value: java.lang.Long))(
        _.fullLoadErrorRows
      )
      .optionallyWith(
        fullLoadStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadStartTime)
      .optionallyWith(
        fullLoadEndTime.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadEndTime)
      .optionallyWith(fullLoadReloaded.map(value => value: java.lang.Boolean))(
        _.fullLoadReloaded
      )
      .optionallyWith(
        lastUpdateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(tableState.map(value => value: java.lang.String))(
        _.tableState
      )
      .optionallyWith(
        validationPendingRecords.map(value => value: java.lang.Long)
      )(_.validationPendingRecords)
      .optionallyWith(
        validationFailedRecords.map(value => value: java.lang.Long)
      )(_.validationFailedRecords)
      .optionallyWith(
        validationSuspendedRecords.map(value => value: java.lang.Long)
      )(_.validationSuspendedRecords)
      .optionallyWith(validationState.map(value => value: java.lang.String))(
        _.validationState
      )
      .optionallyWith(
        validationStateDetails.map(value => value: java.lang.String)
      )(_.validationStateDetails)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.TableStatistics.ReadOnly =
    zio.aws.databasemigration.model.TableStatistics.wrap(buildAwsValue())
}
object TableStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.TableStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.TableStatistics =
      zio.aws.databasemigration.model.TableStatistics(
        schemaName.map(value => value),
        tableName.map(value => value),
        inserts.map(value => value),
        deletes.map(value => value),
        updates.map(value => value),
        ddls.map(value => value),
        fullLoadRows.map(value => value),
        fullLoadCondtnlChkFailedRows.map(value => value),
        fullLoadErrorRows.map(value => value),
        fullLoadStartTime.map(value => value),
        fullLoadEndTime.map(value => value),
        fullLoadReloaded.map(value => value),
        lastUpdateTime.map(value => value),
        tableState.map(value => value),
        validationPendingRecords.map(value => value),
        validationFailedRecords.map(value => value),
        validationSuspendedRecords.map(value => value),
        validationState.map(value => value),
        validationStateDetails.map(value => value)
      )
    def schemaName: Optional[String]
    def tableName: Optional[String]
    def inserts: Optional[Long]
    def deletes: Optional[Long]
    def updates: Optional[Long]
    def ddls: Optional[Long]
    def fullLoadRows: Optional[Long]
    def fullLoadCondtnlChkFailedRows: Optional[Long]
    def fullLoadErrorRows: Optional[Long]
    def fullLoadStartTime: Optional[TStamp]
    def fullLoadEndTime: Optional[TStamp]
    def fullLoadReloaded: Optional[BooleanOptional]
    def lastUpdateTime: Optional[TStamp]
    def tableState: Optional[String]
    def validationPendingRecords: Optional[Long]
    def validationFailedRecords: Optional[Long]
    def validationSuspendedRecords: Optional[Long]
    def validationState: Optional[String]
    def validationStateDetails: Optional[String]
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getInserts: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("inserts", inserts)
    def getDeletes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deletes", deletes)
    def getUpdates: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("updates", updates)
    def getDdls: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("ddls", ddls)
    def getFullLoadRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fullLoadRows", fullLoadRows)
    def getFullLoadCondtnlChkFailedRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "fullLoadCondtnlChkFailedRows",
        fullLoadCondtnlChkFailedRows
      )
    def getFullLoadErrorRows: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fullLoadErrorRows", fullLoadErrorRows)
    def getFullLoadStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadStartTime", fullLoadStartTime)
    def getFullLoadEndTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadEndTime", fullLoadEndTime)
    def getFullLoadReloaded: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("fullLoadReloaded", fullLoadReloaded)
    def getLastUpdateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getTableState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableState", tableState)
    def getValidationPendingRecords: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("validationPendingRecords", validationPendingRecords)
    def getValidationFailedRecords: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("validationFailedRecords", validationFailedRecords)
    def getValidationSuspendedRecords: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "validationSuspendedRecords",
        validationSuspendedRecords
      )
    def getValidationState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("validationState", validationState)
    def getValidationStateDetails: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("validationStateDetails", validationStateDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.TableStatistics
  ) extends zio.aws.databasemigration.model.TableStatistics.ReadOnly {
    override val schemaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaName())
      .map(value => value: String)
    override val tableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => value: String)
    override val inserts: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.inserts())
      .map(value => value: Long)
    override val deletes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.deletes())
      .map(value => value: Long)
    override val updates: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.updates())
      .map(value => value: Long)
    override val ddls: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.ddls())
      .map(value => value: Long)
    override val fullLoadRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fullLoadRows())
      .map(value => value: Long)
    override val fullLoadCondtnlChkFailedRows: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fullLoadCondtnlChkFailedRows())
        .map(value => value: Long)
    override val fullLoadErrorRows: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fullLoadErrorRows())
      .map(value => value: Long)
    override val fullLoadStartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.fullLoadStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadEndTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.fullLoadEndTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadReloaded: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fullLoadReloaded())
        .map(value => value: BooleanOptional)
    override val lastUpdateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val tableState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tableState())
      .map(value => value: String)
    override val validationPendingRecords: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationPendingRecords())
        .map(value => value: Long)
    override val validationFailedRecords: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.validationFailedRecords())
      .map(value => value: Long)
    override val validationSuspendedRecords: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationSuspendedRecords())
        .map(value => value: Long)
    override val validationState: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.validationState())
      .map(value => value: String)
    override val validationStateDetails: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationStateDetails())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.TableStatistics
  ): zio.aws.databasemigration.model.TableStatistics.ReadOnly = new Wrapper(
    impl
  )
}
