package zio.aws.databasemigration
import zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.databasemigration.model.{
  DescribeEventCategoriesRequest,
  CreateEndpointRequest,
  DescribeReplicationTaskAssessmentRunsRequest,
  DescribeRefreshSchemasStatusRequest,
  DescribeSchemasResponse,
  StopReplicationTaskRequest,
  DescribeApplicableIndividualAssessmentsRequest,
  DescribeEventsResponse,
  ModifyEventSubscriptionRequest,
  DescribeFleetAdvisorLsaAnalysisRequest,
  DescribeReplicationTaskAssessmentResultsRequest,
  DeleteEndpointRequest,
  UpdateSubscriptionsToEventBridgeRequest,
  DeleteEndpointResponse,
  ModifyReplicationTaskRequest,
  DeleteConnectionResponse,
  DescribeSchemasRequest,
  DeleteReplicationTaskAssessmentRunResponse,
  TestConnectionRequest,
  DeleteFleetAdvisorCollectorResponse,
  DescribeEndpointsRequest,
  CreateReplicationInstanceResponse,
  DescribeFleetAdvisorSchemaObjectSummaryResponse,
  ModifyReplicationInstanceRequest,
  DescribeFleetAdvisorCollectorsResponse,
  RunFleetAdvisorLsaAnalysisResponse,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  DescribeFleetAdvisorDatabasesRequest,
  CollectorResponse,
  DatabaseResponse,
  StartReplicationTaskAssessmentRunRequest,
  DescribeEventCategoriesResponse,
  RemoveTagsFromResourceResponse,
  DeleteReplicationInstanceResponse,
  StartReplicationTaskResponse,
  UpdateSubscriptionsToEventBridgeResponse,
  ModifyEventSubscriptionResponse,
  DeleteReplicationTaskAssessmentRunRequest,
  DescribeConnectionsRequest,
  DescribeEventsRequest,
  DescribeFleetAdvisorSchemasRequest,
  CancelReplicationTaskAssessmentRunResponse,
  FleetAdvisorLsaAnalysisResponse,
  DescribePendingMaintenanceActionsResponse,
  ApplyPendingMaintenanceActionRequest,
  StartReplicationTaskRequest,
  ModifyReplicationInstanceResponse,
  DescribeReplicationTasksResponse,
  DeleteCertificateResponse,
  DescribeReplicationTaskIndividualAssessmentsResponse,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  DescribeFleetAdvisorCollectorsRequest,
  DescribeOrderableReplicationInstancesResponse,
  DescribeReplicationInstanceTaskLogsRequest,
  DescribeReplicationSubnetGroupsRequest,
  DeleteFleetAdvisorDatabasesRequest,
  ImportCertificateResponse,
  CreateReplicationTaskRequest,
  RefreshSchemasResponse,
  DeleteReplicationSubnetGroupRequest,
  DescribeConnectionsResponse,
  CreateReplicationSubnetGroupResponse,
  ApplyPendingMaintenanceActionResponse,
  ListTagsForResourceResponse,
  DescribeCertificatesResponse,
  DeleteConnectionRequest,
  SchemaResponse,
  DescribeEndpointTypesRequest,
  ReloadTablesRequest,
  CreateFleetAdvisorCollectorRequest,
  DescribeEventSubscriptionsResponse,
  DescribeEndpointsResponse,
  StopReplicationTaskResponse,
  DescribeOrderableReplicationInstancesRequest,
  DescribeEndpointTypesResponse,
  CreateEventSubscriptionResponse,
  ModifyEndpointResponse,
  DescribeReplicationSubnetGroupsResponse,
  RunFleetAdvisorLsaAnalysisRequest,
  RebootReplicationInstanceResponse,
  RemoveTagsFromResourceRequest,
  DeleteReplicationTaskResponse,
  DeleteReplicationTaskRequest,
  FleetAdvisorSchemaObjectResponse,
  DescribeFleetAdvisorSchemaObjectSummaryRequest,
  DescribeReplicationInstanceTaskLogsResponse,
  DeleteFleetAdvisorCollectorRequest,
  DescribeCertificatesRequest,
  DeleteReplicationSubnetGroupResponse,
  DescribePendingMaintenanceActionsRequest,
  DescribeTableStatisticsRequest,
  CreateReplicationInstanceRequest,
  RebootReplicationInstanceRequest,
  CreateFleetAdvisorCollectorResponse,
  DescribeFleetAdvisorDatabasesResponse,
  ModifyReplicationSubnetGroupRequest,
  MoveReplicationTaskRequest,
  CreateEndpointResponse,
  DescribeFleetAdvisorLsaAnalysisResponse,
  CreateReplicationTaskResponse,
  DescribeReplicationInstancesResponse,
  DescribeTableStatisticsResponse,
  DescribeReplicationTaskIndividualAssessmentsRequest,
  DescribeAccountAttributesRequest,
  DescribeReplicationTasksRequest,
  AddTagsToResourceResponse,
  MoveReplicationTaskResponse,
  StartReplicationTaskAssessmentResponse,
  TestConnectionResponse,
  ImportCertificateRequest,
  StartReplicationTaskAssessmentRunResponse,
  ModifyReplicationSubnetGroupResponse,
  DescribeApplicableIndividualAssessmentsResponse,
  DescribeRefreshSchemasStatusResponse,
  DescribeEndpointSettingsResponse,
  DescribeFleetAdvisorSchemasResponse,
  DescribeReplicationInstancesRequest,
  ReloadTablesResponse,
  CreateReplicationSubnetGroupRequest,
  DescribeEndpointSettingsRequest,
  RefreshSchemasRequest,
  DeleteEventSubscriptionResponse,
  DeleteReplicationInstanceRequest,
  DescribeAccountAttributesResponse,
  DescribeEventSubscriptionsRequest,
  CancelReplicationTaskAssessmentRunRequest,
  DescribeReplicationTaskAssessmentRunsResponse,
  ModifyReplicationTaskResponse,
  DeleteFleetAdvisorDatabasesResponse,
  DeleteCertificateRequest,
  ModifyEndpointRequest,
  DescribeReplicationTaskAssessmentResultsResponse,
  StartReplicationTaskAssessmentRequest
}
import software.amazon.awssdk.services.databasemigration.{
  DatabaseMigrationAsyncClientBuilder,
  DatabaseMigrationAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait DatabaseMigration extends AspectSupport[DatabaseMigration] {
  val api: DatabaseMigrationAsyncClient
  def describeFleetAdvisorCollectors(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.CollectorResponse.ReadOnly
  ]
  def describeFleetAdvisorCollectorsPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
  ]
  def addTagsToResource(
      request: zio.aws.databasemigration.model.AddTagsToResourceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
  ]
  def describeOrderableReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
  ]
  def describeReplicationInstanceTaskLogs(
      request: zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
  ]
  def describePendingMaintenanceActions(
      request: zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ]
  def refreshSchemas(
      request: zio.aws.databasemigration.model.RefreshSchemasRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
  ]
  def describeTableStatistics(
      request: zio.aws.databasemigration.model.DescribeTableStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
  ]
  def deleteReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
  ]
  def stopReplicationTask(
      request: zio.aws.databasemigration.model.StopReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
  ]
  def cancelReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
  ]
  def describeRefreshSchemasStatus(
      request: zio.aws.databasemigration.model.DescribeRefreshSchemasStatusRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
  ]
  def startReplicationTask(
      request: zio.aws.databasemigration.model.StartReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
  ]
  def describeCertificates(
      request: zio.aws.databasemigration.model.DescribeCertificatesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
  ]
  def modifyReplicationTask(
      request: zio.aws.databasemigration.model.ModifyReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
  ]
  def deleteEventSubscription(
      request: zio.aws.databasemigration.model.DeleteEventSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
  ]
  def moveReplicationTask(
      request: zio.aws.databasemigration.model.MoveReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
  ]
  def startReplicationTaskAssessment(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
  ]
  def describeReplicationSubnetGroups(
      request: zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemaObjectSummary(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemaObjectSummaryPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): IO[AwsError, ReadOnly]
  def removeTagsFromResource(
      request: zio.aws.databasemigration.model.RemoveTagsFromResourceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
  ]
  def describeReplicationTasks(
      request: zio.aws.databasemigration.model.DescribeReplicationTasksRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
  ]
  def createReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
  ]
  def describeReplicationTaskIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
  ]
  def applyPendingMaintenanceAction(
      request: zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ]
  def describeReplicationTaskAssessmentResults(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
  ]
  def deleteCertificate(
      request: zio.aws.databasemigration.model.DeleteCertificateRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
  ]
  def deleteEndpoint(
      request: zio.aws.databasemigration.model.DeleteEndpointRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
  ]
  def modifyReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
  ]
  def modifyReplicationInstance(
      request: zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
  ]
  def testConnection(
      request: zio.aws.databasemigration.model.TestConnectionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
  ]
  def deleteReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemas(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.SchemaResponse.ReadOnly
  ]
  def describeFleetAdvisorSchemasPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
  ]
  def createReplicationTask(
      request: zio.aws.databasemigration.model.CreateReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
  ]
  def describeFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
  ]
  def describeFleetAdvisorDatabasesPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
  ]
  def modifyEventSubscription(
      request: zio.aws.databasemigration.model.ModifyEventSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
  ]
  def updateSubscriptionsToEventBridge(
      request: zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
  ]
  def describeReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeReplicationInstancesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
  ]
  def describeEventCategories(
      request: zio.aws.databasemigration.model.DescribeEventCategoriesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
  ]
  def createReplicationInstance(
      request: zio.aws.databasemigration.model.CreateReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
  ]
  def deleteReplicationInstance(
      request: zio.aws.databasemigration.model.DeleteReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
  ]
  def createFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
  ]
  def describeApplicableIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
  ]
  def describeReplicationTaskAssessmentRuns(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
  ]
  def describeEndpoints(
      request: zio.aws.databasemigration.model.DescribeEndpointsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
  ]
  def startReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
  ]
  def describeSchemas(
      request: zio.aws.databasemigration.model.DescribeSchemasRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
  ]
  def createEventSubscription(
      request: zio.aws.databasemigration.model.CreateEventSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
  ]
  def describeEndpointSettings(
      request: zio.aws.databasemigration.model.DescribeEndpointSettingsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.databasemigration.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
  ]
  def modifyEndpoint(
      request: zio.aws.databasemigration.model.ModifyEndpointRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
  ]
  def deleteFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorCollectorRequest
  ): IO[AwsError, Unit]
  def deleteConnection(
      request: zio.aws.databasemigration.model.DeleteConnectionRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
  ]
  def deleteFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
  ]
  def createEndpoint(
      request: zio.aws.databasemigration.model.CreateEndpointRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
  ]
  def describeFleetAdvisorLsaAnalysis(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
  ]
  def describeFleetAdvisorLsaAnalysisPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
  ]
  def describeEventSubscriptions(
      request: zio.aws.databasemigration.model.DescribeEventSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
  ]
  def describeEndpointTypes(
      request: zio.aws.databasemigration.model.DescribeEndpointTypesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
  ]
  def describeConnections(
      request: zio.aws.databasemigration.model.DescribeConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
  ]
  def runFleetAdvisorLsaAnalysis(): IO[
    AwsError,
    zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
  ]
  def describeAccountAttributes(
      request: zio.aws.databasemigration.model.DescribeAccountAttributesRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
  ]
  def importCertificate(
      request: zio.aws.databasemigration.model.ImportCertificateRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
  ]
  def reloadTables(
      request: zio.aws.databasemigration.model.ReloadTablesRequest
  ): IO[AwsError, zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly]
  def rebootReplicationInstance(
      request: zio.aws.databasemigration.model.RebootReplicationInstanceRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
  ]
  def deleteReplicationTask(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
  ]
  def describeEvents(
      request: zio.aws.databasemigration.model.DescribeEventsRequest
  ): IO[
    AwsError,
    zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
  ]
}
object DatabaseMigration {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DatabaseMigration] =
    customized(identity)
  def customized(
      customization: DatabaseMigrationAsyncClientBuilder => DatabaseMigrationAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DatabaseMigration] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DatabaseMigrationAsyncClientBuilder => DatabaseMigrationAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DatabaseMigration] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DatabaseMigrationAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      DatabaseMigrationAsyncClient,
      DatabaseMigrationAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      DatabaseMigrationAsyncClient,
      DatabaseMigrationAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new DatabaseMigrationImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class DatabaseMigrationImpl[R](
      override val api: DatabaseMigrationAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DatabaseMigration
      with AwsServiceBase[R] {
    override val serviceName: String = "DatabaseMigration"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DatabaseMigrationImpl[R1] = new DatabaseMigrationImpl(api, newAspect, r)
    def describeFleetAdvisorCollectors(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CollectorResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorCollectorsRequest,
      DescribeFleetAdvisorCollectorsResponse,
      CollectorResponse
    ](
      "describeFleetAdvisorCollectors",
      api.describeFleetAdvisorCollectors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.collectors().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.CollectorResponse.wrap(item))
      .provideEnvironment(r)
    def describeFleetAdvisorCollectorsPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorCollectorsRequest,
      DescribeFleetAdvisorCollectorsResponse
    ]("describeFleetAdvisorCollectors", api.describeFleetAdvisorCollectors)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.wrap
    ).provideEnvironment(r)
    def addTagsToResource(
        request: zio.aws.databasemigration.model.AddTagsToResourceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
    ] =
      asyncRequestResponse[AddTagsToResourceRequest, AddTagsToResourceResponse](
        "addTagsToResource",
        api.addTagsToResource
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.AddTagsToResourceResponse.wrap)
        .provideEnvironment(r)
    def describeOrderableReplicationInstances(
        request: zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOrderableReplicationInstancesRequest,
      DescribeOrderableReplicationInstancesResponse
    ](
      "describeOrderableReplicationInstances",
      api.describeOrderableReplicationInstances
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.wrap
      )
      .provideEnvironment(r)
    def describeReplicationInstanceTaskLogs(
        request: zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationInstanceTaskLogsRequest,
      DescribeReplicationInstanceTaskLogsResponse
    ](
      "describeReplicationInstanceTaskLogs",
      api.describeReplicationInstanceTaskLogs
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.wrap
      )
      .provideEnvironment(r)
    def describePendingMaintenanceActions(
        request: zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePendingMaintenanceActionsRequest,
      DescribePendingMaintenanceActionsResponse
    ]("describePendingMaintenanceActions", api.describePendingMaintenanceActions)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.wrap
    ).provideEnvironment(r)
    def refreshSchemas(
        request: zio.aws.databasemigration.model.RefreshSchemasRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
    ] = asyncRequestResponse[RefreshSchemasRequest, RefreshSchemasResponse](
      "refreshSchemas",
      api.refreshSchemas
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.RefreshSchemasResponse.wrap)
      .provideEnvironment(r)
    def describeTableStatistics(
        request: zio.aws.databasemigration.model.DescribeTableStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTableStatisticsRequest,
      DescribeTableStatisticsResponse
    ]("describeTableStatistics", api.describeTableStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeTableStatisticsResponse.wrap)
      .provideEnvironment(r)
    def deleteReplicationSubnetGroup(
        request: zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationSubnetGroupRequest,
      DeleteReplicationSubnetGroupResponse
    ]("deleteReplicationSubnetGroup", api.deleteReplicationSubnetGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.wrap
    ).provideEnvironment(r)
    def stopReplicationTask(
        request: zio.aws.databasemigration.model.StopReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      StopReplicationTaskRequest,
      StopReplicationTaskResponse
    ]("stopReplicationTask", api.stopReplicationTask)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.StopReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def cancelReplicationTaskAssessmentRun(
        request: zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelReplicationTaskAssessmentRunRequest,
      CancelReplicationTaskAssessmentRunResponse
    ](
      "cancelReplicationTaskAssessmentRun",
      api.cancelReplicationTaskAssessmentRun
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.wrap
      )
      .provideEnvironment(r)
    def describeRefreshSchemasStatus(
        request: zio.aws.databasemigration.model.DescribeRefreshSchemasStatusRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRefreshSchemasStatusRequest,
      DescribeRefreshSchemasStatusResponse
    ]("describeRefreshSchemasStatus", api.describeRefreshSchemasStatus)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.wrap
    ).provideEnvironment(r)
    def startReplicationTask(
        request: zio.aws.databasemigration.model.StartReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      StartReplicationTaskRequest,
      StartReplicationTaskResponse
    ]("startReplicationTask", api.startReplicationTask)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.StartReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def describeCertificates(
        request: zio.aws.databasemigration.model.DescribeCertificatesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCertificatesRequest,
      DescribeCertificatesResponse
    ]("describeCertificates", api.describeCertificates)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeCertificatesResponse.wrap)
      .provideEnvironment(r)
    def modifyReplicationTask(
        request: zio.aws.databasemigration.model.ModifyReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReplicationTaskRequest,
      ModifyReplicationTaskResponse
    ]("modifyReplicationTask", api.modifyReplicationTask)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ModifyReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def deleteEventSubscription(
        request: zio.aws.databasemigration.model.DeleteEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEventSubscriptionRequest,
      DeleteEventSubscriptionResponse
    ]("deleteEventSubscription", api.deleteEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def moveReplicationTask(
        request: zio.aws.databasemigration.model.MoveReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      MoveReplicationTaskRequest,
      MoveReplicationTaskResponse
    ]("moveReplicationTask", api.moveReplicationTask)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.MoveReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def startReplicationTaskAssessment(
        request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      StartReplicationTaskAssessmentRequest,
      StartReplicationTaskAssessmentResponse
    ]("startReplicationTaskAssessment", api.startReplicationTaskAssessment)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.wrap
    ).provideEnvironment(r)
    def describeReplicationSubnetGroups(
        request: zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationSubnetGroupsRequest,
      DescribeReplicationSubnetGroupsResponse
    ]("describeReplicationSubnetGroups", api.describeReplicationSubnetGroups)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.wrap
    ).provideEnvironment(r)
    def describeFleetAdvisorSchemaObjectSummary(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorSchemaObjectSummaryRequest,
      DescribeFleetAdvisorSchemaObjectSummaryResponse,
      FleetAdvisorSchemaObjectResponse
    ](
      "describeFleetAdvisorSchemaObjectSummary",
      api.describeFleetAdvisorSchemaObjectSummary,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fleetAdvisorSchemaObjects().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeFleetAdvisorSchemaObjectSummaryPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DescribeFleetAdvisorSchemaObjectSummaryRequest,
      DescribeFleetAdvisorSchemaObjectSummaryResponse
    ](
      "describeFleetAdvisorSchemaObjectSummary",
      api.describeFleetAdvisorSchemaObjectSummary
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse.wrap
      )
      .provideEnvironment(r)
    def removeTagsFromResource(
        request: zio.aws.databasemigration.model.RemoveTagsFromResourceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.wrap)
      .provideEnvironment(r)
    def describeReplicationTasks(
        request: zio.aws.databasemigration.model.DescribeReplicationTasksRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTasksRequest,
      DescribeReplicationTasksResponse
    ]("describeReplicationTasks", api.describeReplicationTasks)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeReplicationTasksResponse.wrap)
      .provideEnvironment(r)
    def createReplicationSubnetGroup(
        request: zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationSubnetGroupRequest,
      CreateReplicationSubnetGroupResponse
    ]("createReplicationSubnetGroup", api.createReplicationSubnetGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.wrap
    ).provideEnvironment(r)
    def describeReplicationTaskIndividualAssessments(
        request: zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTaskIndividualAssessmentsRequest,
      DescribeReplicationTaskIndividualAssessmentsResponse
    ](
      "describeReplicationTaskIndividualAssessments",
      api.describeReplicationTaskIndividualAssessments
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.wrap
      )
      .provideEnvironment(r)
    def applyPendingMaintenanceAction(
        request: zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      ApplyPendingMaintenanceActionRequest,
      ApplyPendingMaintenanceActionResponse
    ]("applyPendingMaintenanceAction", api.applyPendingMaintenanceAction)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.wrap
    ).provideEnvironment(r)
    def describeReplicationTaskAssessmentResults(
        request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTaskAssessmentResultsRequest,
      DescribeReplicationTaskAssessmentResultsResponse
    ](
      "describeReplicationTaskAssessmentResults",
      api.describeReplicationTaskAssessmentResults
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteCertificate(
        request: zio.aws.databasemigration.model.DeleteCertificateRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteCertificateRequest, DeleteCertificateResponse](
        "deleteCertificate",
        api.deleteCertificate
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.DeleteCertificateResponse.wrap)
        .provideEnvironment(r)
    def deleteEndpoint(
        request: zio.aws.databasemigration.model.DeleteEndpointRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
    ] = asyncRequestResponse[DeleteEndpointRequest, DeleteEndpointResponse](
      "deleteEndpoint",
      api.deleteEndpoint
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DeleteEndpointResponse.wrap)
      .provideEnvironment(r)
    def modifyReplicationSubnetGroup(
        request: zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReplicationSubnetGroupRequest,
      ModifyReplicationSubnetGroupResponse
    ]("modifyReplicationSubnetGroup", api.modifyReplicationSubnetGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.wrap
    ).provideEnvironment(r)
    def modifyReplicationInstance(
        request: zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReplicationInstanceRequest,
      ModifyReplicationInstanceResponse
    ]("modifyReplicationInstance", api.modifyReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def testConnection(
        request: zio.aws.databasemigration.model.TestConnectionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
    ] = asyncRequestResponse[TestConnectionRequest, TestConnectionResponse](
      "testConnection",
      api.testConnection
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.TestConnectionResponse.wrap)
      .provideEnvironment(r)
    def deleteReplicationTaskAssessmentRun(
        request: zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationTaskAssessmentRunRequest,
      DeleteReplicationTaskAssessmentRunResponse
    ](
      "deleteReplicationTaskAssessmentRun",
      api.deleteReplicationTaskAssessmentRun
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.wrap
      )
      .provideEnvironment(r)
    def describeFleetAdvisorSchemas(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SchemaResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorSchemasRequest,
      DescribeFleetAdvisorSchemasResponse,
      SchemaResponse
    ](
      "describeFleetAdvisorSchemas",
      api.describeFleetAdvisorSchemas,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fleetAdvisorSchemas().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.SchemaResponse.wrap(item))
      .provideEnvironment(r)
    def describeFleetAdvisorSchemasPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorSchemasRequest,
      DescribeFleetAdvisorSchemasResponse
    ]("describeFleetAdvisorSchemas", api.describeFleetAdvisorSchemas)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.wrap
    ).provideEnvironment(r)
    def createReplicationTask(
        request: zio.aws.databasemigration.model.CreateReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationTaskRequest,
      CreateReplicationTaskResponse
    ]("createReplicationTask", api.createReplicationTask)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.CreateReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def describeFleetAdvisorDatabases(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorDatabasesRequest,
      DescribeFleetAdvisorDatabasesResponse,
      DatabaseResponse
    ](
      "describeFleetAdvisorDatabases",
      api.describeFleetAdvisorDatabases,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.databases().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.databasemigration.model.DatabaseResponse.wrap(item))
      .provideEnvironment(r)
    def describeFleetAdvisorDatabasesPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorDatabasesRequest,
      DescribeFleetAdvisorDatabasesResponse
    ]("describeFleetAdvisorDatabases", api.describeFleetAdvisorDatabases)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.wrap
    ).provideEnvironment(r)
    def modifyEventSubscription(
        request: zio.aws.databasemigration.model.ModifyEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyEventSubscriptionRequest,
      ModifyEventSubscriptionResponse
    ]("modifyEventSubscription", api.modifyEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def updateSubscriptionsToEventBridge(
        request: zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSubscriptionsToEventBridgeRequest,
      UpdateSubscriptionsToEventBridgeResponse
    ]("updateSubscriptionsToEventBridge", api.updateSubscriptionsToEventBridge)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.wrap
    ).provideEnvironment(r)
    def describeReplicationInstances(
        request: zio.aws.databasemigration.model.DescribeReplicationInstancesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationInstancesRequest,
      DescribeReplicationInstancesResponse
    ]("describeReplicationInstances", api.describeReplicationInstances)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.wrap
    ).provideEnvironment(r)
    def describeEventCategories(
        request: zio.aws.databasemigration.model.DescribeEventCategoriesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEventCategoriesRequest,
      DescribeEventCategoriesResponse
    ]("describeEventCategories", api.describeEventCategories)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeEventCategoriesResponse.wrap)
      .provideEnvironment(r)
    def createReplicationInstance(
        request: zio.aws.databasemigration.model.CreateReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplicationInstanceRequest,
      CreateReplicationInstanceResponse
    ]("createReplicationInstance", api.createReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.CreateReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def deleteReplicationInstance(
        request: zio.aws.databasemigration.model.DeleteReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationInstanceRequest,
      DeleteReplicationInstanceResponse
    ]("deleteReplicationInstance", api.deleteReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def createFleetAdvisorCollector(
        request: zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateFleetAdvisorCollectorRequest,
      CreateFleetAdvisorCollectorResponse
    ]("createFleetAdvisorCollector", api.createFleetAdvisorCollector)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.wrap
    ).provideEnvironment(r)
    def describeApplicableIndividualAssessments(
        request: zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeApplicableIndividualAssessmentsRequest,
      DescribeApplicableIndividualAssessmentsResponse
    ](
      "describeApplicableIndividualAssessments",
      api.describeApplicableIndividualAssessments
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.wrap
      )
      .provideEnvironment(r)
    def describeReplicationTaskAssessmentRuns(
        request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplicationTaskAssessmentRunsRequest,
      DescribeReplicationTaskAssessmentRunsResponse
    ](
      "describeReplicationTaskAssessmentRuns",
      api.describeReplicationTaskAssessmentRuns
    )(request.buildAwsValue())
      .map(
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.wrap
      )
      .provideEnvironment(r)
    def describeEndpoints(
        request: zio.aws.databasemigration.model.DescribeEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeEndpointsRequest, DescribeEndpointsResponse](
        "describeEndpoints",
        api.describeEndpoints
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.DescribeEndpointsResponse.wrap)
        .provideEnvironment(r)
    def startReplicationTaskAssessmentRun(
        request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
    ] = asyncRequestResponse[
      StartReplicationTaskAssessmentRunRequest,
      StartReplicationTaskAssessmentRunResponse
    ]("startReplicationTaskAssessmentRun", api.startReplicationTaskAssessmentRun)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.wrap
    ).provideEnvironment(r)
    def describeSchemas(
        request: zio.aws.databasemigration.model.DescribeSchemasRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
    ] = asyncRequestResponse[DescribeSchemasRequest, DescribeSchemasResponse](
      "describeSchemas",
      api.describeSchemas
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeSchemasResponse.wrap)
      .provideEnvironment(r)
    def createEventSubscription(
        request: zio.aws.databasemigration.model.CreateEventSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEventSubscriptionRequest,
      CreateEventSubscriptionResponse
    ]("createEventSubscription", api.createEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.CreateEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeEndpointSettings(
        request: zio.aws.databasemigration.model.DescribeEndpointSettingsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEndpointSettingsRequest,
      DescribeEndpointSettingsResponse
    ]("describeEndpointSettings", api.describeEndpointSettings)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.databasemigration.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def modifyEndpoint(
        request: zio.aws.databasemigration.model.ModifyEndpointRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
    ] = asyncRequestResponse[ModifyEndpointRequest, ModifyEndpointResponse](
      "modifyEndpoint",
      api.modifyEndpoint
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ModifyEndpointResponse.wrap)
      .provideEnvironment(r)
    def deleteFleetAdvisorCollector(
        request: zio.aws.databasemigration.model.DeleteFleetAdvisorCollectorRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteFleetAdvisorCollectorRequest,
      DeleteFleetAdvisorCollectorResponse
    ]("deleteFleetAdvisorCollector", api.deleteFleetAdvisorCollector)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteConnection(
        request: zio.aws.databasemigration.model.DeleteConnectionRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
    ] = asyncRequestResponse[DeleteConnectionRequest, DeleteConnectionResponse](
      "deleteConnection",
      api.deleteConnection
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DeleteConnectionResponse.wrap)
      .provideEnvironment(r)
    def deleteFleetAdvisorDatabases(
        request: zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteFleetAdvisorDatabasesRequest,
      DeleteFleetAdvisorDatabasesResponse
    ]("deleteFleetAdvisorDatabases", api.deleteFleetAdvisorDatabases)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.wrap
    ).provideEnvironment(r)
    def createEndpoint(
        request: zio.aws.databasemigration.model.CreateEndpointRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
    ] = asyncRequestResponse[CreateEndpointRequest, CreateEndpointResponse](
      "createEndpoint",
      api.createEndpoint
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.CreateEndpointResponse.wrap)
      .provideEnvironment(r)
    def describeFleetAdvisorLsaAnalysis(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFleetAdvisorLsaAnalysisRequest,
      DescribeFleetAdvisorLsaAnalysisResponse,
      FleetAdvisorLsaAnalysisResponse
    ](
      "describeFleetAdvisorLsaAnalysis",
      api.describeFleetAdvisorLsaAnalysis,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.analysis().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeFleetAdvisorLsaAnalysisPaginated(
        request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFleetAdvisorLsaAnalysisRequest,
      DescribeFleetAdvisorLsaAnalysisResponse
    ]("describeFleetAdvisorLsaAnalysis", api.describeFleetAdvisorLsaAnalysis)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.wrap
    ).provideEnvironment(r)
    def describeEventSubscriptions(
        request: zio.aws.databasemigration.model.DescribeEventSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEventSubscriptionsRequest,
      DescribeEventSubscriptionsResponse
    ]("describeEventSubscriptions", api.describeEventSubscriptions)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.wrap
    ).provideEnvironment(r)
    def describeEndpointTypes(
        request: zio.aws.databasemigration.model.DescribeEndpointTypesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEndpointTypesRequest,
      DescribeEndpointTypesResponse
    ]("describeEndpointTypes", api.describeEndpointTypes)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DescribeEndpointTypesResponse.wrap)
      .provideEnvironment(r)
    def describeConnections(
        request: zio.aws.databasemigration.model.DescribeConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConnectionsRequest,
      DescribeConnectionsResponse
    ]("describeConnections", api.describeConnections)(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeConnectionsResponse.wrap)
      .provideEnvironment(r)
    def runFleetAdvisorLsaAnalysis(): IO[
      AwsError,
      zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      RunFleetAdvisorLsaAnalysisRequest,
      RunFleetAdvisorLsaAnalysisResponse
    ]("runFleetAdvisorLsaAnalysis", api.runFleetAdvisorLsaAnalysis)(
      RunFleetAdvisorLsaAnalysisRequest.builder().build()
    ).map(
      zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.wrap
    ).provideEnvironment(r)
    def describeAccountAttributes(
        request: zio.aws.databasemigration.model.DescribeAccountAttributesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.DescribeAccountAttributesResponse.wrap
    ).provideEnvironment(r)
    def importCertificate(
        request: zio.aws.databasemigration.model.ImportCertificateRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
    ] =
      asyncRequestResponse[ImportCertificateRequest, ImportCertificateResponse](
        "importCertificate",
        api.importCertificate
      )(request.buildAwsValue())
        .map(zio.aws.databasemigration.model.ImportCertificateResponse.wrap)
        .provideEnvironment(r)
    def reloadTables(
        request: zio.aws.databasemigration.model.ReloadTablesRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
    ] = asyncRequestResponse[ReloadTablesRequest, ReloadTablesResponse](
      "reloadTables",
      api.reloadTables
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.ReloadTablesResponse.wrap)
      .provideEnvironment(r)
    def rebootReplicationInstance(
        request: zio.aws.databasemigration.model.RebootReplicationInstanceRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      RebootReplicationInstanceRequest,
      RebootReplicationInstanceResponse
    ]("rebootReplicationInstance", api.rebootReplicationInstance)(
      request.buildAwsValue()
    ).map(
      zio.aws.databasemigration.model.RebootReplicationInstanceResponse.wrap
    ).provideEnvironment(r)
    def deleteReplicationTask(
        request: zio.aws.databasemigration.model.DeleteReplicationTaskRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteReplicationTaskRequest,
      DeleteReplicationTaskResponse
    ]("deleteReplicationTask", api.deleteReplicationTask)(
      request.buildAwsValue()
    ).map(zio.aws.databasemigration.model.DeleteReplicationTaskResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(
        request: zio.aws.databasemigration.model.DescribeEventsRequest
    ): IO[
      AwsError,
      zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
    ] = asyncRequestResponse[DescribeEventsRequest, DescribeEventsResponse](
      "describeEvents",
      api.describeEvents
    )(request.buildAwsValue())
      .map(zio.aws.databasemigration.model.DescribeEventsResponse.wrap)
      .provideEnvironment(r)
  }
  def describeFleetAdvisorCollectors(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CollectorResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorCollectors(request))
  def describeFleetAdvisorCollectorsPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorCollectorsPaginated(request))
  def addTagsToResource(
      request: zio.aws.databasemigration.model.AddTagsToResourceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTagsToResource(request))
  def describeOrderableReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrderableReplicationInstances(request))
  def describeReplicationInstanceTaskLogs(
      request: zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationInstanceTaskLogs(request))
  def describePendingMaintenanceActions(
      request: zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePendingMaintenanceActions(request))
  def refreshSchemas(
      request: zio.aws.databasemigration.model.RefreshSchemasRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.refreshSchemas(request))
  def describeTableStatistics(
      request: zio.aws.databasemigration.model.DescribeTableStatisticsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTableStatistics(request))
  def deleteReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.DeleteReplicationSubnetGroupRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationSubnetGroup(request))
  def stopReplicationTask(
      request: zio.aws.databasemigration.model.StopReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopReplicationTask(request))
  def cancelReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelReplicationTaskAssessmentRun(request))
  def describeRefreshSchemasStatus(
      request: zio.aws.databasemigration.model.DescribeRefreshSchemasStatusRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRefreshSchemasStatus(request))
  def startReplicationTask(
      request: zio.aws.databasemigration.model.StartReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplicationTask(request))
  def describeCertificates(
      request: zio.aws.databasemigration.model.DescribeCertificatesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificates(request))
  def modifyReplicationTask(
      request: zio.aws.databasemigration.model.ModifyReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationTask(request))
  def deleteEventSubscription(
      request: zio.aws.databasemigration.model.DeleteEventSubscriptionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventSubscription(request))
  def moveReplicationTask(
      request: zio.aws.databasemigration.model.MoveReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.moveReplicationTask(request))
  def startReplicationTaskAssessment(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplicationTaskAssessment(request))
  def describeReplicationSubnetGroups(
      request: zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationSubnetGroups(request))
  def describeFleetAdvisorSchemaObjectSummary(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeFleetAdvisorSchemaObjectSummary(request)
  )
  def describeFleetAdvisorSchemaObjectSummaryPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest
  ): ZIO[zio.aws.databasemigration.DatabaseMigration, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(
      _.describeFleetAdvisorSchemaObjectSummaryPaginated(request)
    )
  def removeTagsFromResource(
      request: zio.aws.databasemigration.model.RemoveTagsFromResourceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def describeReplicationTasks(
      request: zio.aws.databasemigration.model.DescribeReplicationTasksRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationTasks(request))
  def createReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationSubnetGroup(request))
  def describeReplicationTaskIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeReplicationTaskIndividualAssessments(request))
  def applyPendingMaintenanceAction(
      request: zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applyPendingMaintenanceAction(request))
  def describeReplicationTaskAssessmentResults(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationTaskAssessmentResults(request))
  def deleteCertificate(
      request: zio.aws.databasemigration.model.DeleteCertificateRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCertificate(request))
  def deleteEndpoint(
      request: zio.aws.databasemigration.model.DeleteEndpointRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def modifyReplicationSubnetGroup(
      request: zio.aws.databasemigration.model.ModifyReplicationSubnetGroupRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationSubnetGroup(request))
  def modifyReplicationInstance(
      request: zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReplicationInstance(request))
  def testConnection(
      request: zio.aws.databasemigration.model.TestConnectionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testConnection(request))
  def deleteReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationTaskAssessmentRun(request))
  def describeFleetAdvisorSchemas(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.SchemaResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorSchemas(request))
  def describeFleetAdvisorSchemasPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorSchemasPaginated(request))
  def createReplicationTask(
      request: zio.aws.databasemigration.model.CreateReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationTask(request))
  def describeFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DatabaseResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorDatabases(request))
  def describeFleetAdvisorDatabasesPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorDatabasesPaginated(request))
  def modifyEventSubscription(
      request: zio.aws.databasemigration.model.ModifyEventSubscriptionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEventSubscription(request))
  def updateSubscriptionsToEventBridge(
      request: zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSubscriptionsToEventBridge(request))
  def describeReplicationInstances(
      request: zio.aws.databasemigration.model.DescribeReplicationInstancesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationInstances(request))
  def describeEventCategories(
      request: zio.aws.databasemigration.model.DescribeEventCategoriesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventCategories(request))
  def createReplicationInstance(
      request: zio.aws.databasemigration.model.CreateReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplicationInstance(request))
  def deleteReplicationInstance(
      request: zio.aws.databasemigration.model.DeleteReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationInstance(request))
  def createFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.CreateFleetAdvisorCollectorRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateFleetAdvisorCollectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleetAdvisorCollector(request))
  def describeApplicableIndividualAssessments(
      request: zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicableIndividualAssessments(request))
  def describeReplicationTaskAssessmentRuns(
      request: zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplicationTaskAssessmentRuns(request))
  def describeEndpoints(
      request: zio.aws.databasemigration.model.DescribeEndpointsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoints(request))
  def startReplicationTaskAssessmentRun(
      request: zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReplicationTaskAssessmentRun(request))
  def describeSchemas(
      request: zio.aws.databasemigration.model.DescribeSchemasRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSchemas(request))
  def createEventSubscription(
      request: zio.aws.databasemigration.model.CreateEventSubscriptionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventSubscription(request))
  def describeEndpointSettings(
      request: zio.aws.databasemigration.model.DescribeEndpointSettingsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointSettings(request))
  def listTagsForResource(
      request: zio.aws.databasemigration.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def modifyEndpoint(
      request: zio.aws.databasemigration.model.ModifyEndpointRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEndpoint(request))
  def deleteFleetAdvisorCollector(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorCollectorRequest
  ): ZIO[zio.aws.databasemigration.DatabaseMigration, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFleetAdvisorCollector(request))
  def deleteConnection(
      request: zio.aws.databasemigration.model.DeleteConnectionRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConnection(request))
  def deleteFleetAdvisorDatabases(
      request: zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteFleetAdvisorDatabasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFleetAdvisorDatabases(request))
  def createEndpoint(
      request: zio.aws.databasemigration.model.CreateEndpointRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpoint(request))
  def describeFleetAdvisorLsaAnalysis(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): ZStream[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFleetAdvisorLsaAnalysis(request))
  def describeFleetAdvisorLsaAnalysisPaginated(
      request: zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetAdvisorLsaAnalysisPaginated(request))
  def describeEventSubscriptions(
      request: zio.aws.databasemigration.model.DescribeEventSubscriptionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSubscriptions(request))
  def describeEndpointTypes(
      request: zio.aws.databasemigration.model.DescribeEndpointTypesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpointTypes(request))
  def describeConnections(
      request: zio.aws.databasemigration.model.DescribeConnectionsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnections(request))
  def runFleetAdvisorLsaAnalysis(): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.runFleetAdvisorLsaAnalysis())
  def describeAccountAttributes(
      request: zio.aws.databasemigration.model.DescribeAccountAttributesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributes(request))
  def importCertificate(
      request: zio.aws.databasemigration.model.ImportCertificateRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importCertificate(request))
  def reloadTables(
      request: zio.aws.databasemigration.model.ReloadTablesRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reloadTables(request))
  def rebootReplicationInstance(
      request: zio.aws.databasemigration.model.RebootReplicationInstanceRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootReplicationInstance(request))
  def deleteReplicationTask(
      request: zio.aws.databasemigration.model.DeleteReplicationTaskRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReplicationTask(request))
  def describeEvents(
      request: zio.aws.databasemigration.model.DescribeEventsRequest
  ): ZIO[
    zio.aws.databasemigration.DatabaseMigration,
    AwsError,
    zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEvents(request))
}
