package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEndpointSettingsResponse(
    marker: Optional[String] = Optional.Absent,
    endpointSettings: Optional[
      Iterable[zio.aws.databasemigration.model.EndpointSetting]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse = {
    import DescribeEndpointSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        endpointSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeEndpointSettingsResponse
      .wrap(buildAwsValue())
}
object DescribeEndpointSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeEndpointSettingsResponse =
      zio.aws.databasemigration.model.DescribeEndpointSettingsResponse(
        marker.map(value => value),
        endpointSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def endpointSettings: Optional[
      List[zio.aws.databasemigration.model.EndpointSetting.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getEndpointSettings: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.EndpointSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointSettings", endpointSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse
  ) extends zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val endpointSettings: Optional[
      List[zio.aws.databasemigration.model.EndpointSetting.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.EndpointSetting.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse
  ): zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
