package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait StartReplicationTaskTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue
}
object StartReplicationTaskTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue
  ): zio.aws.databasemigration.model.StartReplicationTaskTypeValue =
    value match {
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.START_REPLICATION =>
        val r = `start-replication`
        r
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.RESUME_PROCESSING =>
        val r = `resume-processing`
        r
      case software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.RELOAD_TARGET =>
        val r = `reload-target`
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.StartReplicationTaskTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object `start-replication`
      extends zio.aws.databasemigration.model.StartReplicationTaskTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.START_REPLICATION
  }
  case object `resume-processing`
      extends zio.aws.databasemigration.model.StartReplicationTaskTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.RESUME_PROCESSING
  }
  case object `reload-target`
      extends zio.aws.databasemigration.model.StartReplicationTaskTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue =
      software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskTypeValue.RELOAD_TARGET
  }
}
