package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountQuota(
    accountQuotaName: Optional[String] = Optional.Absent,
    used: Optional[Long] = Optional.Absent,
    max: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.AccountQuota = {
    import AccountQuota.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.AccountQuota
      .builder()
      .optionallyWith(accountQuotaName.map(value => value: java.lang.String))(
        _.accountQuotaName
      )
      .optionallyWith(used.map(value => value: java.lang.Long))(_.used)
      .optionallyWith(max.map(value => value: java.lang.Long))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.AccountQuota.ReadOnly =
    zio.aws.databasemigration.model.AccountQuota.wrap(buildAwsValue())
}
object AccountQuota {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.AccountQuota
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.AccountQuota =
      zio.aws.databasemigration.model.AccountQuota(
        accountQuotaName.map(value => value),
        used.map(value => value),
        max.map(value => value)
      )
    def accountQuotaName: Optional[String]
    def used: Optional[Long]
    def max: Optional[Long]
    def getAccountQuotaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountQuotaName", accountQuotaName)
    def getUsed: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("used", used)
    def getMax: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.AccountQuota
  ) extends zio.aws.databasemigration.model.AccountQuota.ReadOnly {
    override val accountQuotaName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountQuotaName())
      .map(value => value: String)
    override val used: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.used())
      .map(value => value: Long)
    override val max: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.AccountQuota
  ): zio.aws.databasemigration.model.AccountQuota.ReadOnly = new Wrapper(impl)
}
