package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait ParquetVersionValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue
}
object ParquetVersionValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue
  ): zio.aws.databasemigration.model.ParquetVersionValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue.PARQUET_1_0 =>
      val r = `parquet-1-0`
      r
    case software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue.PARQUET_2_0 =>
      val r = `parquet-2-0`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.ParquetVersionValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue =
      software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue.UNKNOWN_TO_SDK_VERSION
  }
  case object `parquet-1-0`
      extends zio.aws.databasemigration.model.ParquetVersionValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue =
      software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue.PARQUET_1_0
  }
  case object `parquet-2-0`
      extends zio.aws.databasemigration.model.ParquetVersionValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue =
      software.amazon.awssdk.services.databasemigration.model.ParquetVersionValue.PARQUET_2_0
  }
}
