package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventCategoriesRequest(
    sourceType: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.databasemigration.model.Filter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest = {
    import DescribeEventCategoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEventCategoriesRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeEventCategoriesRequest
      .wrap(buildAwsValue())
}
object DescribeEventCategoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeEventCategoriesRequest =
      zio.aws.databasemigration.model.DescribeEventCategoriesRequest(
        sourceType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceType: Optional[String]
    def filters: Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest
  ) extends zio.aws.databasemigration.model.DescribeEventCategoriesRequest.ReadOnly {
    override val sourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => value: String)
    override val filters
        : Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest
  ): zio.aws.databasemigration.model.DescribeEventCategoriesRequest.ReadOnly =
    new Wrapper(impl)
}
