package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait CannedAclForObjectsValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue
}
object CannedAclForObjectsValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue
  ): zio.aws.databasemigration.model.CannedAclForObjectsValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.PUBLIC_READ =>
      val r = `public-read`
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.PUBLIC_READ_WRITE =>
      val r = `public-read-write`
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.AUTHENTICATED_READ =>
      val r = `authenticated-read`
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.AWS_EXEC_READ =>
      val r = `aws-exec-read`
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.BUCKET_OWNER_READ =>
      val r = `bucket-owner-read`
      r
    case software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.BUCKET_OWNER_FULL_CONTROL =>
      val r = `bucket-owner-full-control`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.UNKNOWN_TO_SDK_VERSION
  }
  case object none
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.NONE
  }
  case object `private`
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.PRIVATE
  }
  case object `public-read`
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.PUBLIC_READ
  }
  case object `public-read-write`
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.PUBLIC_READ_WRITE
  }
  case object `authenticated-read`
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.AUTHENTICATED_READ
  }
  case object `aws-exec-read`
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.AWS_EXEC_READ
  }
  case object `bucket-owner-read`
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.BUCKET_OWNER_READ
  }
  case object `bucket-owner-full-control`
      extends zio.aws.databasemigration.model.CannedAclForObjectsValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue =
      software.amazon.awssdk.services.databasemigration.model.CannedAclForObjectsValue.BUCKET_OWNER_FULL_CONTROL
  }
}
