package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateReplicationTaskRequest(
    replicationTaskIdentifier: String,
    sourceEndpointArn: String,
    targetEndpointArn: String,
    replicationInstanceArn: String,
    migrationType: zio.aws.databasemigration.model.MigrationTypeValue,
    tableMappings: String,
    replicationTaskSettings: Optional[String] = Optional.Absent,
    cdcStartTime: Optional[TStamp] = Optional.Absent,
    cdcStartPosition: Optional[String] = Optional.Absent,
    cdcStopPosition: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent,
    taskData: Optional[String] = Optional.Absent,
    resourceIdentifier: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest = {
    import CreateReplicationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
      .builder()
      .replicationTaskIdentifier(replicationTaskIdentifier: java.lang.String)
      .sourceEndpointArn(sourceEndpointArn: java.lang.String)
      .targetEndpointArn(targetEndpointArn: java.lang.String)
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .migrationType(migrationType.unwrap)
      .tableMappings(tableMappings: java.lang.String)
      .optionallyWith(
        replicationTaskSettings.map(value => value: java.lang.String)
      )(_.replicationTaskSettings)
      .optionallyWith(cdcStartTime.map(value => TStamp.unwrap(value): Instant))(
        _.cdcStartTime
      )
      .optionallyWith(cdcStartPosition.map(value => value: java.lang.String))(
        _.cdcStartPosition
      )
      .optionallyWith(cdcStopPosition.map(value => value: java.lang.String))(
        _.cdcStopPosition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(taskData.map(value => value: java.lang.String))(
        _.taskData
      )
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationTaskRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationTaskRequest
      .wrap(buildAwsValue())
}
object CreateReplicationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationTaskRequest =
      zio.aws.databasemigration.model.CreateReplicationTaskRequest(
        replicationTaskIdentifier,
        sourceEndpointArn,
        targetEndpointArn,
        replicationInstanceArn,
        migrationType,
        tableMappings,
        replicationTaskSettings.map(value => value),
        cdcStartTime.map(value => value),
        cdcStartPosition.map(value => value),
        cdcStopPosition.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskData.map(value => value),
        resourceIdentifier.map(value => value)
      )
    def replicationTaskIdentifier: String
    def sourceEndpointArn: String
    def targetEndpointArn: String
    def replicationInstanceArn: String
    def migrationType: zio.aws.databasemigration.model.MigrationTypeValue
    def tableMappings: String
    def replicationTaskSettings: Optional[String]
    def cdcStartTime: Optional[TStamp]
    def cdcStartPosition: Optional[String]
    def cdcStopPosition: Optional[String]
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def taskData: Optional[String]
    def resourceIdentifier: Optional[String]
    def getReplicationTaskIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskIdentifier)
    def getSourceEndpointArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetEndpointArn)
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getMigrationType: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = ZIO.succeed(migrationType)
    def getTableMappings: ZIO[Any, Nothing, String] = ZIO.succeed(tableMappings)
    def getReplicationTaskSettings: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationTaskSettings", replicationTaskSettings)
    def getCdcStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("cdcStartTime", cdcStartTime)
    def getCdcStartPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStartPosition", cdcStartPosition)
    def getCdcStopPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdcStopPosition", cdcStopPosition)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getTaskData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskData", taskData)
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
  ) extends zio.aws.databasemigration.model.CreateReplicationTaskRequest.ReadOnly {
    override val replicationTaskIdentifier: String =
      impl.replicationTaskIdentifier(): String
    override val sourceEndpointArn: String = impl.sourceEndpointArn(): String
    override val targetEndpointArn: String = impl.targetEndpointArn(): String
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val migrationType
        : zio.aws.databasemigration.model.MigrationTypeValue =
      zio.aws.databasemigration.model.MigrationTypeValue
        .wrap(impl.migrationType())
    override val tableMappings: String = impl.tableMappings(): String
    override val replicationTaskSettings: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskSettings())
        .map(value => value: String)
    override val cdcStartTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val cdcStartPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStartPosition())
      .map(value => value: String)
    override val cdcStopPosition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdcStopPosition())
      .map(value => value: String)
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
    override val taskData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskData())
      .map(value => value: String)
    override val resourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifier())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest
  ): zio.aws.databasemigration.model.CreateReplicationTaskRequest.ReadOnly =
    new Wrapper(impl)
}
