package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplyPendingMaintenanceActionRequest(
    replicationInstanceArn: String,
    applyAction: String,
    optInType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest = {
    import ApplyPendingMaintenanceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .applyAction(applyAction: java.lang.String)
      .optInType(optInType: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest.ReadOnly =
    zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest
      .wrap(buildAwsValue())
}
object ApplyPendingMaintenanceActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest =
      zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest(
        replicationInstanceArn,
        applyAction,
        optInType
      )
    def replicationInstanceArn: String
    def applyAction: String
    def optInType: String
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getApplyAction: ZIO[Any, Nothing, String] = ZIO.succeed(applyAction)
    def getOptInType: ZIO[Any, Nothing, String] = ZIO.succeed(optInType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest
  ) extends zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val applyAction: String = impl.applyAction(): String
    override val optInType: String = impl.optInType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest
  ): zio.aws.databasemigration.model.ApplyPendingMaintenanceActionRequest.ReadOnly =
    new Wrapper(impl)
}
