package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartReplicationTaskAssessmentResponse(
    replicationTask: Optional[zio.aws.databasemigration.model.ReplicationTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse = {
    import StartReplicationTaskAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse
      .builder()
      .optionallyWith(replicationTask.map(value => value.buildAwsValue()))(
        _.replicationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly =
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse
      .wrap(buildAwsValue())
}
object StartReplicationTaskAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse =
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse(
        replicationTask.map(value => value.asEditable)
      )
    def replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    def getReplicationTask: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTask", replicationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse
  ) extends zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly {
    override val replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTask())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse
  ): zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
