package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceArn: Optional[String] = Optional.Absent,
    resourceArnList: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(
        resourceArnList.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceArnList)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.databasemigration.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ListTagsForResourceRequest =
      zio.aws.databasemigration.model.ListTagsForResourceRequest(
        resourceArn.map(value => value),
        resourceArnList.map(value => value)
      )
    def resourceArn: Optional[String]
    def resourceArnList: Optional[List[String]]
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceArnList: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceArnList", resourceArnList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest
  ) extends zio.aws.databasemigration.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
    override val resourceArnList: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArnList())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest
  ): zio.aws.databasemigration.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
