package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  SecretString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SybaseSettings(
    databaseName: Optional[String] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.SybaseSettings = {
    import SybaseSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.SybaseSettings
      .builder()
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.SybaseSettings.ReadOnly =
    zio.aws.databasemigration.model.SybaseSettings.wrap(buildAwsValue())
}
object SybaseSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.SybaseSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.SybaseSettings =
      zio.aws.databasemigration.model.SybaseSettings(
        databaseName.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        username.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def databaseName: Optional[String]
    def password: Optional[SecretString]
    def port: Optional[IntegerOptional]
    def serverName: Optional[String]
    def username: Optional[String]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.SybaseSettings
  ) extends zio.aws.databasemigration.model.SybaseSettings.ReadOnly {
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.SybaseSettings
  ): zio.aws.databasemigration.model.SybaseSettings.ReadOnly = new Wrapper(impl)
}
