package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateReplicationInstanceResponse(
    replicationInstance: Optional[
      zio.aws.databasemigration.model.ReplicationInstance
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse = {
    import CreateReplicationInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse
      .builder()
      .optionallyWith(replicationInstance.map(value => value.buildAwsValue()))(
        _.replicationInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationInstanceResponse
      .wrap(buildAwsValue())
}
object CreateReplicationInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationInstanceResponse =
      zio.aws.databasemigration.model.CreateReplicationInstanceResponse(
        replicationInstance.map(value => value.asEditable)
      )
    def replicationInstance
        : Optional[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly]
    def getReplicationInstance: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationInstance.ReadOnly
    ] = AwsError.unwrapOptionField("replicationInstance", replicationInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse
  ) extends zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly {
    override val replicationInstance: Optional[
      zio.aws.databasemigration.model.ReplicationInstance.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationInstance())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationInstance.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse
  ): zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
