package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReplicationTasksResponse(
    marker: Optional[String] = Optional.Absent,
    replicationTasks: Optional[
      Iterable[zio.aws.databasemigration.model.ReplicationTask]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse = {
    import DescribeReplicationTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        replicationTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationTasks)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTasksResponse
      .wrap(buildAwsValue())
}
object DescribeReplicationTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTasksResponse =
      zio.aws.databasemigration.model.DescribeReplicationTasksResponse(
        marker.map(value => value),
        replicationTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def replicationTasks: Optional[
      List[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReplicationTasks: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationTasks", replicationTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse
  ) extends zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val replicationTasks: Optional[
      List[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse
  ): zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly =
    new Wrapper(impl)
}
