package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters._
sealed trait MigrationTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue
}
object MigrationTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue
  ): zio.aws.databasemigration.model.MigrationTypeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.FULL_LOAD =>
      val r = `full-load`
      r
    case software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.CDC =>
      val r = cdc
      r
    case software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.FULL_LOAD_AND_CDC =>
      val r = `full-load-and-cdc`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.MigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object `full-load`
      extends zio.aws.databasemigration.model.MigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.FULL_LOAD
  }
  case object cdc extends zio.aws.databasemigration.model.MigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.CDC
  }
  case object `full-load-and-cdc`
      extends zio.aws.databasemigration.model.MigrationTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue =
      software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue.FULL_LOAD_AND_CDC
  }
}
