package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ReplicationPendingModifiedValues(
    replicationInstanceClass: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues = {
    import ReplicationPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
      .builder()
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly =
    zio.aws.databasemigration.model.ReplicationPendingModifiedValues
      .wrap(buildAwsValue())
}
object ReplicationPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationPendingModifiedValues =
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues(
        replicationInstanceClass.map(value => value),
        allocatedStorage.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value)
      )
    def replicationInstanceClass: Optional[String]
    def allocatedStorage: Optional[IntegerOptional]
    def multiAZ: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
  ) extends zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly {
    override val replicationInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceClass())
        .map(value => value: String)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationPendingModifiedValues
  ): zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly =
    new Wrapper(impl)
}
