package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromResourceRequest(
    resourceArn: String,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest = {
    import RemoveTagsFromResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RemoveTagsFromResourceRequest.ReadOnly =
    zio.aws.databasemigration.model.RemoveTagsFromResourceRequest
      .wrap(buildAwsValue())
}
object RemoveTagsFromResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.RemoveTagsFromResourceRequest =
      zio.aws.databasemigration.model
        .RemoveTagsFromResourceRequest(resourceArn, tagKeys)
    def resourceArn: String
    def tagKeys: List[String]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest
  ) extends zio.aws.databasemigration.model.RemoveTagsFromResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest
  ): zio.aws.databasemigration.model.RemoveTagsFromResourceRequest.ReadOnly =
    new Wrapper(impl)
}
