package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePendingMaintenanceActionsResponse(
    pendingMaintenanceActions: Optional[Iterable[
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions
    ]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse = {
    import DescribePendingMaintenanceActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse
      .builder()
      .optionallyWith(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse
      .wrap(buildAwsValue())
}
object DescribePendingMaintenanceActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse =
      zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def pendingMaintenanceActions: Optional[List[
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly
    ]]
    def marker: Optional[String]
    def getPendingMaintenanceActions: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActions",
      pendingMaintenanceActions
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse
  ) extends zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly {
    override val pendingMaintenanceActions: Optional[List[
      zio.aws.databasemigration.model.ResourcePendingMaintenanceActions.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingMaintenanceActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.ResourcePendingMaintenanceActions
            .wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse
  ): zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly =
    new Wrapper(impl)
}
