package zio.aws.databasemigration
import zio.aws.databasemigration.model.DescribeEventsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient
import zio.aws.core.AwsError
import zio.aws.databasemigration.model.{
  DescribeEventCategoriesRequest,
  CreateEndpointRequest,
  DescribeReplicationTaskAssessmentRunsRequest,
  DescribeRefreshSchemasStatusRequest,
  StopReplicationTaskRequest,
  DescribeApplicableIndividualAssessmentsRequest,
  ModifyEventSubscriptionRequest,
  DescribeReplicationTaskAssessmentResultsRequest,
  DeleteEndpointRequest,
  ModifyReplicationTaskRequest,
  DescribeSchemasRequest,
  TestConnectionRequest,
  DescribeEndpointsRequest,
  ModifyReplicationInstanceRequest,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  StartReplicationTaskAssessmentRunRequest,
  DeleteReplicationTaskAssessmentRunRequest,
  DescribeConnectionsRequest,
  DescribeEventsRequest,
  ApplyPendingMaintenanceActionRequest,
  StartReplicationTaskRequest,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  DescribeReplicationInstanceTaskLogsRequest,
  DescribeReplicationSubnetGroupsRequest,
  CreateReplicationTaskRequest,
  DeleteReplicationSubnetGroupRequest,
  DeleteConnectionRequest,
  DescribeEndpointTypesRequest,
  ReloadTablesRequest,
  DescribeOrderableReplicationInstancesRequest,
  RemoveTagsFromResourceRequest,
  DeleteReplicationTaskRequest,
  DescribeCertificatesRequest,
  DescribePendingMaintenanceActionsRequest,
  DescribeTableStatisticsRequest,
  CreateReplicationInstanceRequest,
  RebootReplicationInstanceRequest,
  ModifyReplicationSubnetGroupRequest,
  MoveReplicationTaskRequest,
  DescribeReplicationTaskIndividualAssessmentsRequest,
  DescribeAccountAttributesRequest,
  DescribeReplicationTasksRequest,
  ImportCertificateRequest,
  DescribeReplicationInstancesRequest,
  CreateReplicationSubnetGroupRequest,
  DescribeEndpointSettingsRequest,
  RefreshSchemasRequest,
  DeleteReplicationInstanceRequest,
  DescribeEventSubscriptionsRequest,
  CancelReplicationTaskAssessmentRunRequest,
  DeleteCertificateRequest,
  ModifyEndpointRequest,
  StartReplicationTaskAssessmentRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object DatabaseMigrationMock extends Mock[DatabaseMigration] {
  object AddTagsToResource
      extends Effect[
        AddTagsToResourceRequest,
        AwsError,
        zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
      ]
  object DescribeOrderableReplicationInstances
      extends Effect[
        DescribeOrderableReplicationInstancesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
      ]
  object DescribeReplicationInstanceTaskLogs
      extends Effect[
        DescribeReplicationInstanceTaskLogsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
      ]
  object DescribePendingMaintenanceActions
      extends Effect[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
      ]
  object RefreshSchemas
      extends Effect[
        RefreshSchemasRequest,
        AwsError,
        zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
      ]
  object DescribeTableStatistics
      extends Effect[
        DescribeTableStatisticsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
      ]
  object DeleteReplicationSubnetGroup
      extends Effect[
        DeleteReplicationSubnetGroupRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
      ]
  object StopReplicationTask
      extends Effect[
        StopReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
      ]
  object CancelReplicationTaskAssessmentRun
      extends Effect[
        CancelReplicationTaskAssessmentRunRequest,
        AwsError,
        zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
      ]
  object DescribeRefreshSchemasStatus
      extends Effect[
        DescribeRefreshSchemasStatusRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
      ]
  object StartReplicationTask
      extends Effect[
        StartReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
      ]
  object DescribeCertificates
      extends Effect[
        DescribeCertificatesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
      ]
  object ModifyReplicationTask
      extends Effect[
        ModifyReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
      ]
  object DeleteEventSubscription
      extends Effect[
        DeleteEventSubscriptionRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
      ]
  object MoveReplicationTask
      extends Effect[
        MoveReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
      ]
  object StartReplicationTaskAssessment
      extends Effect[
        StartReplicationTaskAssessmentRequest,
        AwsError,
        zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
      ]
  object DescribeReplicationSubnetGroups
      extends Effect[
        DescribeReplicationSubnetGroupsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[
        RemoveTagsFromResourceRequest,
        AwsError,
        zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
      ]
  object DescribeReplicationTasks
      extends Effect[
        DescribeReplicationTasksRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
      ]
  object CreateReplicationSubnetGroup
      extends Effect[
        CreateReplicationSubnetGroupRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
      ]
  object DescribeReplicationTaskIndividualAssessments
      extends Effect[
        DescribeReplicationTaskIndividualAssessmentsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
      ]
  object ApplyPendingMaintenanceAction
      extends Effect[
        ApplyPendingMaintenanceActionRequest,
        AwsError,
        zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
      ]
  object DescribeReplicationTaskAssessmentResults
      extends Effect[
        DescribeReplicationTaskAssessmentResultsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
      ]
  object DeleteCertificate
      extends Effect[
        DeleteCertificateRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
      ]
  object DeleteEndpoint
      extends Effect[
        DeleteEndpointRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
      ]
  object ModifyReplicationSubnetGroup
      extends Effect[
        ModifyReplicationSubnetGroupRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
      ]
  object ModifyReplicationInstance
      extends Effect[
        ModifyReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
      ]
  object TestConnection
      extends Effect[
        TestConnectionRequest,
        AwsError,
        zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
      ]
  object DeleteReplicationTaskAssessmentRun
      extends Effect[
        DeleteReplicationTaskAssessmentRunRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
      ]
  object CreateReplicationTask
      extends Effect[
        CreateReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
      ]
  object ModifyEventSubscription
      extends Effect[
        ModifyEventSubscriptionRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
      ]
  object DescribeReplicationInstances
      extends Effect[
        DescribeReplicationInstancesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
      ]
  object DescribeEventCategories
      extends Effect[
        DescribeEventCategoriesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
      ]
  object CreateReplicationInstance
      extends Effect[
        CreateReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
      ]
  object DeleteReplicationInstance
      extends Effect[
        DeleteReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
      ]
  object DescribeApplicableIndividualAssessments
      extends Effect[
        DescribeApplicableIndividualAssessmentsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
      ]
  object DescribeReplicationTaskAssessmentRuns
      extends Effect[
        DescribeReplicationTaskAssessmentRunsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
      ]
  object DescribeEndpoints
      extends Effect[
        DescribeEndpointsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
      ]
  object StartReplicationTaskAssessmentRun
      extends Effect[
        StartReplicationTaskAssessmentRunRequest,
        AwsError,
        zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
      ]
  object DescribeSchemas
      extends Effect[
        DescribeSchemasRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
      ]
  object CreateEventSubscription
      extends Effect[
        CreateEventSubscriptionRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
      ]
  object DescribeEndpointSettings
      extends Effect[
        DescribeEndpointSettingsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ModifyEndpoint
      extends Effect[
        ModifyEndpointRequest,
        AwsError,
        zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
      ]
  object DeleteConnection
      extends Effect[
        DeleteConnectionRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
      ]
  object CreateEndpoint
      extends Effect[
        CreateEndpointRequest,
        AwsError,
        zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
      ]
  object DescribeEventSubscriptions
      extends Effect[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
      ]
  object DescribeEndpointTypes
      extends Effect[
        DescribeEndpointTypesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
      ]
  object DescribeConnections
      extends Effect[
        DescribeConnectionsRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
      ]
  object DescribeAccountAttributes
      extends Effect[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object ImportCertificate
      extends Effect[
        ImportCertificateRequest,
        AwsError,
        zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
      ]
  object ReloadTables
      extends Effect[
        ReloadTablesRequest,
        AwsError,
        zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
      ]
  object RebootReplicationInstance
      extends Effect[
        RebootReplicationInstanceRequest,
        AwsError,
        zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
      ]
  object DeleteReplicationTask
      extends Effect[
        DeleteReplicationTaskRequest,
        AwsError,
        zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
      ]
  object DescribeEvents
      extends Effect[DescribeEventsRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, DatabaseMigration] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new DatabaseMigration {
          val api: DatabaseMigrationAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : DatabaseMigration = this
          def addTagsToResource(request: AddTagsToResourceRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.AddTagsToResourceResponse.ReadOnly
          ] = proxy(AddTagsToResource, request)
          def describeOrderableReplicationInstances(
              request: DescribeOrderableReplicationInstancesRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeOrderableReplicationInstancesResponse.ReadOnly
          ] = proxy(DescribeOrderableReplicationInstances, request)
          def describeReplicationInstanceTaskLogs(
              request: DescribeReplicationInstanceTaskLogsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse.ReadOnly
          ] = proxy(DescribeReplicationInstanceTaskLogs, request)
          def describePendingMaintenanceActions(
              request: DescribePendingMaintenanceActionsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribePendingMaintenanceActionsResponse.ReadOnly
          ] = proxy(DescribePendingMaintenanceActions, request)
          def refreshSchemas(request: RefreshSchemasRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly
          ] = proxy(RefreshSchemas, request)
          def describeTableStatistics(
              request: DescribeTableStatisticsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeTableStatisticsResponse.ReadOnly
          ] = proxy(DescribeTableStatistics, request)
          def deleteReplicationSubnetGroup(
              request: DeleteReplicationSubnetGroupRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteReplicationSubnetGroupResponse.ReadOnly
          ] = proxy(DeleteReplicationSubnetGroup, request)
          def stopReplicationTask(request: StopReplicationTaskRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.StopReplicationTaskResponse.ReadOnly
          ] = proxy(StopReplicationTask, request)
          def cancelReplicationTaskAssessmentRun(
              request: CancelReplicationTaskAssessmentRunRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.CancelReplicationTaskAssessmentRunResponse.ReadOnly
          ] = proxy(CancelReplicationTaskAssessmentRun, request)
          def describeRefreshSchemasStatus(
              request: DescribeRefreshSchemasStatusRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly
          ] = proxy(DescribeRefreshSchemasStatus, request)
          def startReplicationTask(request: StartReplicationTaskRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly
          ] = proxy(StartReplicationTask, request)
          def describeCertificates(request: DescribeCertificatesRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeCertificatesResponse.ReadOnly
          ] = proxy(DescribeCertificates, request)
          def modifyReplicationTask(request: ModifyReplicationTaskRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.ModifyReplicationTaskResponse.ReadOnly
          ] = proxy(ModifyReplicationTask, request)
          def deleteEventSubscription(
              request: DeleteEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteEventSubscriptionResponse.ReadOnly
          ] = proxy(DeleteEventSubscription, request)
          def moveReplicationTask(request: MoveReplicationTaskRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.MoveReplicationTaskResponse.ReadOnly
          ] = proxy(MoveReplicationTask, request)
          def startReplicationTaskAssessment(
              request: StartReplicationTaskAssessmentRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.StartReplicationTaskAssessmentResponse.ReadOnly
          ] = proxy(StartReplicationTaskAssessment, request)
          def describeReplicationSubnetGroups(
              request: DescribeReplicationSubnetGroupsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeReplicationSubnetGroupsResponse.ReadOnly
          ] = proxy(DescribeReplicationSubnetGroups, request)
          def removeTagsFromResource(
              request: RemoveTagsFromResourceRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.RemoveTagsFromResourceResponse.ReadOnly
          ] = proxy(RemoveTagsFromResource, request)
          def describeReplicationTasks(
              request: DescribeReplicationTasksRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeReplicationTasksResponse.ReadOnly
          ] = proxy(DescribeReplicationTasks, request)
          def createReplicationSubnetGroup(
              request: CreateReplicationSubnetGroupRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.CreateReplicationSubnetGroupResponse.ReadOnly
          ] = proxy(CreateReplicationSubnetGroup, request)
          def describeReplicationTaskIndividualAssessments(
              request: DescribeReplicationTaskIndividualAssessmentsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse.ReadOnly
          ] = proxy(DescribeReplicationTaskIndividualAssessments, request)
          def applyPendingMaintenanceAction(
              request: ApplyPendingMaintenanceActionRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.ApplyPendingMaintenanceActionResponse.ReadOnly
          ] = proxy(ApplyPendingMaintenanceAction, request)
          def describeReplicationTaskAssessmentResults(
              request: DescribeReplicationTaskAssessmentResultsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse.ReadOnly
          ] = proxy(DescribeReplicationTaskAssessmentResults, request)
          def deleteCertificate(request: DeleteCertificateRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly
          ] = proxy(DeleteCertificate, request)
          def deleteEndpoint(request: DeleteEndpointRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteEndpointResponse.ReadOnly
          ] = proxy(DeleteEndpoint, request)
          def modifyReplicationSubnetGroup(
              request: ModifyReplicationSubnetGroupRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.ModifyReplicationSubnetGroupResponse.ReadOnly
          ] = proxy(ModifyReplicationSubnetGroup, request)
          def modifyReplicationInstance(
              request: ModifyReplicationInstanceRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly
          ] = proxy(ModifyReplicationInstance, request)
          def testConnection(request: TestConnectionRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly
          ] = proxy(TestConnection, request)
          def deleteReplicationTaskAssessmentRun(
              request: DeleteReplicationTaskAssessmentRunRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly
          ] = proxy(DeleteReplicationTaskAssessmentRun, request)
          def createReplicationTask(request: CreateReplicationTaskRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.CreateReplicationTaskResponse.ReadOnly
          ] = proxy(CreateReplicationTask, request)
          def modifyEventSubscription(
              request: ModifyEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.ModifyEventSubscriptionResponse.ReadOnly
          ] = proxy(ModifyEventSubscription, request)
          def describeReplicationInstances(
              request: DescribeReplicationInstancesRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeReplicationInstancesResponse.ReadOnly
          ] = proxy(DescribeReplicationInstances, request)
          def describeEventCategories(
              request: DescribeEventCategoriesRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeEventCategoriesResponse.ReadOnly
          ] = proxy(DescribeEventCategories, request)
          def createReplicationInstance(
              request: CreateReplicationInstanceRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.CreateReplicationInstanceResponse.ReadOnly
          ] = proxy(CreateReplicationInstance, request)
          def deleteReplicationInstance(
              request: DeleteReplicationInstanceRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteReplicationInstanceResponse.ReadOnly
          ] = proxy(DeleteReplicationInstance, request)
          def describeApplicableIndividualAssessments(
              request: DescribeApplicableIndividualAssessmentsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse.ReadOnly
          ] = proxy(DescribeApplicableIndividualAssessments, request)
          def describeReplicationTaskAssessmentRuns(
              request: DescribeReplicationTaskAssessmentRunsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse.ReadOnly
          ] = proxy(DescribeReplicationTaskAssessmentRuns, request)
          def describeEndpoints(request: DescribeEndpointsRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeEndpointsResponse.ReadOnly
          ] = proxy(DescribeEndpoints, request)
          def startReplicationTaskAssessmentRun(
              request: StartReplicationTaskAssessmentRunRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunResponse.ReadOnly
          ] = proxy(StartReplicationTaskAssessmentRun, request)
          def describeSchemas(request: DescribeSchemasRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeSchemasResponse.ReadOnly
          ] = proxy(DescribeSchemas, request)
          def createEventSubscription(
              request: CreateEventSubscriptionRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.CreateEventSubscriptionResponse.ReadOnly
          ] = proxy(CreateEventSubscription, request)
          def describeEndpointSettings(
              request: DescribeEndpointSettingsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeEndpointSettingsResponse.ReadOnly
          ] = proxy(DescribeEndpointSettings, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def modifyEndpoint(request: ModifyEndpointRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.ModifyEndpointResponse.ReadOnly
          ] = proxy(ModifyEndpoint, request)
          def deleteConnection(request: DeleteConnectionRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly
          ] = proxy(DeleteConnection, request)
          def createEndpoint(request: CreateEndpointRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly
          ] = proxy(CreateEndpoint, request)
          def describeEventSubscriptions(
              request: DescribeEventSubscriptionsRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeEventSubscriptionsResponse.ReadOnly
          ] = proxy(DescribeEventSubscriptions, request)
          def describeEndpointTypes(request: DescribeEndpointTypesRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly
          ] = proxy(DescribeEndpointTypes, request)
          def describeConnections(request: DescribeConnectionsRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly
          ] = proxy(DescribeConnections, request)
          def describeAccountAttributes(
              request: DescribeAccountAttributesRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.DescribeAccountAttributesResponse.ReadOnly
          ] = proxy(DescribeAccountAttributes, request)
          def importCertificate(request: ImportCertificateRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.ImportCertificateResponse.ReadOnly
          ] = proxy(ImportCertificate, request)
          def reloadTables(request: ReloadTablesRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.ReloadTablesResponse.ReadOnly
          ] = proxy(ReloadTables, request)
          def rebootReplicationInstance(
              request: RebootReplicationInstanceRequest
          ): IO[
            AwsError,
            zio.aws.databasemigration.model.RebootReplicationInstanceResponse.ReadOnly
          ] = proxy(RebootReplicationInstance, request)
          def deleteReplicationTask(request: DeleteReplicationTaskRequest): IO[
            AwsError,
            zio.aws.databasemigration.model.DeleteReplicationTaskResponse.ReadOnly
          ] = proxy(DeleteReplicationTask, request)
          def describeEvents(
              request: DescribeEventsRequest
          ): IO[AwsError, ReadOnly] = proxy(DescribeEvents, request)
        }
      }
    }
  }
}
