package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.databasemigration.model.primitives.{TStamp, Integer}
import scala.jdk.CollectionConverters._
final case class ReplicationTaskStats(
    fullLoadProgressPercent: Option[Integer] = None,
    elapsedTimeMillis: Option[Long] = None,
    tablesLoaded: Option[Integer] = None,
    tablesLoading: Option[Integer] = None,
    tablesQueued: Option[Integer] = None,
    tablesErrored: Option[Integer] = None,
    freshStartDate: Option[TStamp] = None,
    startDate: Option[TStamp] = None,
    stopDate: Option[TStamp] = None,
    fullLoadStartDate: Option[TStamp] = None,
    fullLoadFinishDate: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats = {
    import ReplicationTaskStats.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
      .builder()
      .optionallyWith(
        fullLoadProgressPercent.map(value => value: java.lang.Integer)
      )(_.fullLoadProgressPercent)
      .optionallyWith(elapsedTimeMillis.map(value => value: java.lang.Long))(
        _.elapsedTimeMillis
      )
      .optionallyWith(tablesLoaded.map(value => value: java.lang.Integer))(
        _.tablesLoaded
      )
      .optionallyWith(tablesLoading.map(value => value: java.lang.Integer))(
        _.tablesLoading
      )
      .optionallyWith(tablesQueued.map(value => value: java.lang.Integer))(
        _.tablesQueued
      )
      .optionallyWith(tablesErrored.map(value => value: java.lang.Integer))(
        _.tablesErrored
      )
      .optionallyWith(
        freshStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.freshStartDate)
      .optionallyWith(startDate.map(value => TStamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(stopDate.map(value => TStamp.unwrap(value): Instant))(
        _.stopDate
      )
      .optionallyWith(
        fullLoadStartDate.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadStartDate)
      .optionallyWith(
        fullLoadFinishDate.map(value => TStamp.unwrap(value): Instant)
      )(_.fullLoadFinishDate)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskStats.wrap(buildAwsValue())
}
object ReplicationTaskStats {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationTaskStats =
      zio.aws.databasemigration.model.ReplicationTaskStats(
        fullLoadProgressPercent.map(value => value),
        elapsedTimeMillis.map(value => value),
        tablesLoaded.map(value => value),
        tablesLoading.map(value => value),
        tablesQueued.map(value => value),
        tablesErrored.map(value => value),
        freshStartDate.map(value => value),
        startDate.map(value => value),
        stopDate.map(value => value),
        fullLoadStartDate.map(value => value),
        fullLoadFinishDate.map(value => value)
      )
    def fullLoadProgressPercent: Option[Integer]
    def elapsedTimeMillis: Option[Long]
    def tablesLoaded: Option[Integer]
    def tablesLoading: Option[Integer]
    def tablesQueued: Option[Integer]
    def tablesErrored: Option[Integer]
    def freshStartDate: Option[TStamp]
    def startDate: Option[TStamp]
    def stopDate: Option[TStamp]
    def fullLoadStartDate: Option[TStamp]
    def fullLoadFinishDate: Option[TStamp]
    def getFullLoadProgressPercent: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("fullLoadProgressPercent", fullLoadProgressPercent)
    def getElapsedTimeMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeMillis", elapsedTimeMillis)
    def getTablesLoaded: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesLoaded", tablesLoaded)
    def getTablesLoading: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesLoading", tablesLoading)
    def getTablesQueued: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesQueued", tablesQueued)
    def getTablesErrored: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("tablesErrored", tablesErrored)
    def getFreshStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("freshStartDate", freshStartDate)
    def getStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getStopDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
    def getFullLoadStartDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadStartDate", fullLoadStartDate)
    def getFullLoadFinishDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("fullLoadFinishDate", fullLoadFinishDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
  ) extends zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly {
    override val fullLoadProgressPercent: Option[Integer] =
      scala.Option(impl.fullLoadProgressPercent()).map(value => value: Integer)
    override val elapsedTimeMillis: Option[Long] =
      scala.Option(impl.elapsedTimeMillis()).map(value => value: Long)
    override val tablesLoaded: Option[Integer] =
      scala.Option(impl.tablesLoaded()).map(value => value: Integer)
    override val tablesLoading: Option[Integer] =
      scala.Option(impl.tablesLoading()).map(value => value: Integer)
    override val tablesQueued: Option[Integer] =
      scala.Option(impl.tablesQueued()).map(value => value: Integer)
    override val tablesErrored: Option[Integer] =
      scala.Option(impl.tablesErrored()).map(value => value: Integer)
    override val freshStartDate: Option[TStamp] = scala
      .Option(impl.freshStartDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val startDate: Option[TStamp] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val stopDate: Option[TStamp] = scala
      .Option(impl.stopDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadStartDate: Option[TStamp] = scala
      .Option(impl.fullLoadStartDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val fullLoadFinishDate: Option[TStamp] = scala
      .Option(impl.fullLoadFinishDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskStats
  ): zio.aws.databasemigration.model.ReplicationTaskStats.ReadOnly =
    new Wrapper(impl)
}
