package zio.aws.databasemigration.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  BooleanOptional
}
import scala.jdk.CollectionConverters._
final case class EndpointSetting(
    name: Option[String] = None,
    `type`: Option[zio.aws.databasemigration.model.EndpointSettingTypeValue] =
      None,
    enumValues: Option[Iterable[String]] = None,
    sensitive: Option[BooleanOptional] = None,
    units: Option[String] = None,
    applicability: Option[String] = None,
    intValueMin: Option[IntegerOptional] = None,
    intValueMax: Option[IntegerOptional] = None,
    defaultValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.EndpointSetting = {
    import EndpointSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.EndpointSetting
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        enumValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enumValues)
      .optionallyWith(sensitive.map(value => value: java.lang.Boolean))(
        _.sensitive
      )
      .optionallyWith(units.map(value => value: java.lang.String))(_.units)
      .optionallyWith(applicability.map(value => value: java.lang.String))(
        _.applicability
      )
      .optionallyWith(intValueMin.map(value => value: Integer))(_.intValueMin)
      .optionallyWith(intValueMax.map(value => value: Integer))(_.intValueMax)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.EndpointSetting.ReadOnly =
    zio.aws.databasemigration.model.EndpointSetting.wrap(buildAwsValue())
}
object EndpointSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.EndpointSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.EndpointSetting =
      zio.aws.databasemigration.model.EndpointSetting(
        name.map(value => value),
        `type`.map(value => value),
        enumValues.map(value => value),
        sensitive.map(value => value),
        units.map(value => value),
        applicability.map(value => value),
        intValueMin.map(value => value),
        intValueMax.map(value => value),
        defaultValue.map(value => value)
      )
    def name: Option[String]
    def `type`: Option[zio.aws.databasemigration.model.EndpointSettingTypeValue]
    def enumValues: Option[List[String]]
    def sensitive: Option[BooleanOptional]
    def units: Option[String]
    def applicability: Option[String]
    def intValueMin: Option[IntegerOptional]
    def intValueMax: Option[IntegerOptional]
    def defaultValue: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EndpointSettingTypeValue
    ] = AwsError.unwrapOptionField("type", `type`)
    def getEnumValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("enumValues", enumValues)
    def getSensitive: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("sensitive", sensitive)
    def getUnits: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("units", units)
    def getApplicability: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applicability", applicability)
    def getIntValueMin: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("intValueMin", intValueMin)
    def getIntValueMax: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("intValueMax", intValueMax)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.EndpointSetting
  ) extends zio.aws.databasemigration.model.EndpointSetting.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val `type`
        : Option[zio.aws.databasemigration.model.EndpointSettingTypeValue] =
      scala
        .Option(impl.`type`())
        .map(value =>
          zio.aws.databasemigration.model.EndpointSettingTypeValue.wrap(value)
        )
    override val enumValues: Option[List[String]] = scala
      .Option(impl.enumValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sensitive: Option[BooleanOptional] =
      scala.Option(impl.sensitive()).map(value => value: BooleanOptional)
    override val units: Option[String] =
      scala.Option(impl.units()).map(value => value: String)
    override val applicability: Option[String] =
      scala.Option(impl.applicability()).map(value => value: String)
    override val intValueMin: Option[IntegerOptional] =
      scala.Option(impl.intValueMin()).map(value => value: IntegerOptional)
    override val intValueMax: Option[IntegerOptional] =
      scala.Option(impl.intValueMax()).map(value => value: IntegerOptional)
    override val defaultValue: Option[String] =
      scala.Option(impl.defaultValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.EndpointSetting
  ): zio.aws.databasemigration.model.EndpointSetting.ReadOnly = new Wrapper(
    impl
  )
}
